/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.img;

import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.IORuntimeException;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FontUtil {
    public static Font createFont() {
        return new Font(null);
    }

    public static Font createSansSerifFont(int n2) {
        return FontUtil.createFont("SansSerif", n2);
    }

    public static Font createFont(String string, int n2) {
        return new Font(string, 0, n2);
    }

    public static Font createFont(File file) {
        try {
            return Font.createFont(0, file);
        }
        catch (FontFormatException fontFormatException) {
            try {
                return Font.createFont(1, file);
            }
            catch (Exception exception) {
                throw new UtilException(fontFormatException);
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static Font createFont(InputStream inputStream) {
        try {
            return Font.createFont(0, inputStream);
        }
        catch (FontFormatException fontFormatException) {
            try {
                return Font.createFont(1, inputStream);
            }
            catch (Exception exception) {
                throw new UtilException(exception);
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static Dimension getDimension(FontMetrics fontMetrics, String string) {
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent();
        return new Dimension(n2, n3);
    }
}

