/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date;

import com.ccb.core.date.DateUnit;
import com.ccb.core.date.DateUtil;
import java.io.Serializable;

public class TimeInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long time;
    private final boolean isNano;

    public TimeInterval() {
        this(false);
    }

    public TimeInterval(boolean bl) {
        this.isNano = bl;
        this.start();
    }

    public long start() {
        this.time = DateUtil.current(this.isNano);
        return this.time;
    }

    public long intervalRestart() {
        long l2 = DateUtil.current(this.isNano);
        long l3 = l2 - this.time;
        this.time = l2;
        return l3;
    }

    public TimeInterval restart() {
        this.time = DateUtil.current(this.isNano);
        return this;
    }

    public long interval() {
        return DateUtil.current(this.isNano) - this.time;
    }

    public String intervalPretty() {
        return DateUtil.formatBetween(this.intervalMs());
    }

    public long intervalMs() {
        return this.isNano ? this.interval() / 1000000L : this.interval();
    }

    public long intervalSecond() {
        return this.intervalMs() / DateUnit.SECOND.getMillis();
    }

    public long intervalMinute() {
        return this.intervalMs() / DateUnit.MINUTE.getMillis();
    }

    public long intervalHour() {
        return this.intervalMs() / DateUnit.HOUR.getMillis();
    }

    public long intervalDay() {
        return this.intervalMs() / DateUnit.DAY.getMillis();
    }

    public long intervalWeek() {
        return this.intervalMs() / DateUnit.WEEK.getMillis();
    }
}

