/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.convert.ConverterRegistry;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.TypeUtil;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;

public class ReferenceConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private final Class targetType;

    public ReferenceConverter(Class clazz) {
        this.targetType = clazz;
    }

    @Override
    protected Reference convertInternal(Object object) {
        Object object2 = null;
        Type type = TypeUtil.getTypeArgument(this.targetType);
        if (!TypeUtil.isUnknown(type)) {
            object2 = ConverterRegistry.getInstance().convert(type, object);
        }
        if (null == object2) {
            object2 = object;
        }
        if (this.targetType == WeakReference.class) {
            return new WeakReference<Object>(object2);
        }
        if (this.targetType == SoftReference.class) {
            return new SoftReference<Object>(object2);
        }
        throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport Reference type: {}", this.targetType.getName()));
    }
}

