/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.convert.ConvertException;
import com.ccb.core.date.DateUtil;
import com.ccb.core.util.BooleanUtil;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.StrUtil;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class PrimitiveConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private final Class targetType;

    public PrimitiveConverter(Class clazz) {
        if (null == clazz) {
            throw new NullPointerException("PrimitiveConverter not allow null target type!");
        }
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException("[" + clazz + "] is not a primitive class!");
        }
        this.targetType = clazz;
    }

    @Override
    protected Object convertInternal(Object object) {
        if (Byte.TYPE == this.targetType) {
            if (object instanceof Number) {
                return ((Number)object).byteValue();
            }
            if (object instanceof Boolean) {
                return BooleanUtil.toByte((Boolean)object);
            }
            String string = this.convertToStr(object);
            if (StrUtil.isBlank(string)) {
                return 0;
            }
            return Byte.parseByte(string);
        }
        if (Short.TYPE == this.targetType) {
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
            if (object instanceof Boolean) {
                return BooleanUtil.toShort((Boolean)object);
            }
            String string = this.convertToStr(object);
            if (StrUtil.isBlank(string)) {
                return 0;
            }
            return Short.parseShort(string);
        }
        if (Integer.TYPE == this.targetType) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            if (object instanceof Boolean) {
                return BooleanUtil.toInt((Boolean)object);
            }
            if (object instanceof Date) {
                return ((Date)object).getTime();
            }
            if (object instanceof Calendar) {
                return ((Calendar)object).getTimeInMillis();
            }
            if (object instanceof TemporalAccessor) {
                return DateUtil.toInstant((TemporalAccessor)object).toEpochMilli();
            }
            String string = this.convertToStr(object);
            if (StrUtil.isBlank(string)) {
                return 0;
            }
            return NumberUtil.parseInt(string);
        }
        if (Long.TYPE == this.targetType) {
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            if (object instanceof Boolean) {
                return BooleanUtil.toLong((Boolean)object);
            }
            if (object instanceof Date) {
                return ((Date)object).getTime();
            }
            if (object instanceof Calendar) {
                return ((Calendar)object).getTimeInMillis();
            }
            if (object instanceof TemporalAccessor) {
                return DateUtil.toInstant((TemporalAccessor)object).toEpochMilli();
            }
            String string = this.convertToStr(object);
            if (StrUtil.isBlank(string)) {
                return 0;
            }
            return NumberUtil.parseLong(string);
        }
        if (Float.TYPE == this.targetType) {
            if (object instanceof Number) {
                return Float.valueOf(((Number)object).floatValue());
            }
            if (object instanceof Boolean) {
                return Float.valueOf(BooleanUtil.toFloat((Boolean)object));
            }
            String string = this.convertToStr(object);
            if (StrUtil.isBlank(string)) {
                return 0;
            }
            return Float.valueOf(Float.parseFloat(string));
        }
        if (Double.TYPE == this.targetType) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            if (object instanceof Boolean) {
                return BooleanUtil.toDouble((Boolean)object);
            }
            String string = this.convertToStr(object);
            if (StrUtil.isBlank(string)) {
                return 0;
            }
            return Double.parseDouble(string);
        }
        if (Character.TYPE == this.targetType) {
            if (object instanceof Character) {
                return Character.valueOf(((Character)object).charValue());
            }
            if (object instanceof Boolean) {
                return Character.valueOf(BooleanUtil.toChar((Boolean)object));
            }
            String string = this.convertToStr(object);
            if (StrUtil.isBlank(string)) {
                return 0;
            }
            return Character.valueOf(string.charAt(0));
        }
        if (Boolean.TYPE == this.targetType) {
            if (object instanceof Boolean) {
                return (boolean)((Boolean)object);
            }
            String string = this.convertToStr(object);
            return BooleanUtil.toBoolean(string);
        }
        throw new ConvertException("Unsupported target type: {}", this.targetType);
    }

    @Override
    protected String convertToStr(Object object) {
        return StrUtil.trim(super.convertToStr(object));
    }

    @Override
    public Class getTargetType() {
        return this.targetType;
    }
}

