/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.codec;

import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import java.nio.charset.Charset;

public class Base64Encoder {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};

    public static byte[] encode(byte[] byArray, boolean bl) {
        return Base64Encoder.encode(byArray, bl, false);
    }

    public static byte[] encodeUrlSafe(byte[] byArray, boolean bl) {
        return Base64Encoder.encode(byArray, bl, true);
    }

    public static String encode(CharSequence charSequence) {
        return Base64Encoder.encode(charSequence, DEFAULT_CHARSET);
    }

    public static String encodeUrlSafe(CharSequence charSequence) {
        return Base64Encoder.encodeUrlSafe(charSequence, DEFAULT_CHARSET);
    }

    public static String encode(CharSequence charSequence, Charset charset) {
        return Base64Encoder.encode(StrUtil.bytes(charSequence, charset));
    }

    public static String encodeUrlSafe(CharSequence charSequence, Charset charset) {
        return Base64Encoder.encodeUrlSafe(StrUtil.bytes(charSequence, charset));
    }

    public static String encode(byte[] byArray) {
        return StrUtil.str(Base64Encoder.encode(byArray, false), DEFAULT_CHARSET);
    }

    public static String encodeUrlSafe(byte[] byArray) {
        return StrUtil.str(Base64Encoder.encodeUrlSafe(byArray, false), DEFAULT_CHARSET);
    }

    public static byte[] encode(byte[] byArray, boolean bl, boolean bl2) {
        if (null == byArray) {
            return null;
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n2 / 3 * 3;
        int n4 = (n2 - 1) / 3 + 1 << 2;
        int n5 = n4 + (bl ? (n4 - 1) / 76 << 1 : 0);
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = bl2 ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n6 < n3) {
            int n9 = (byArray[n6++] & 0xFF) << 16 | (byArray[n6++] & 0xFF) << 8 | byArray[n6++] & 0xFF;
            byArray2[n7++] = byArray3[n9 >>> 18 & 0x3F];
            byArray2[n7++] = byArray3[n9 >>> 12 & 0x3F];
            byArray2[n7++] = byArray3[n9 >>> 6 & 0x3F];
            byArray2[n7++] = byArray3[n9 & 0x3F];
            if (!bl || ++n8 != 19 || n7 >= n5 - 2) continue;
            byArray2[n7++] = 13;
            byArray2[n7++] = 10;
            n8 = 0;
        }
        n6 = n2 - n3;
        if (n6 > 0) {
            n7 = (byArray[n3] & 0xFF) << 10 | (n6 == 2 ? (byArray[n2 - 1] & 0xFF) << 2 : 0);
            byArray2[n5 - 4] = byArray3[n7 >> 12];
            byArray2[n5 - 3] = byArray3[n7 >>> 6 & 0x3F];
            if (bl2) {
                n8 = n5 - 2;
                if (2 == n6) {
                    byArray2[n5 - 2] = byArray3[n7 & 0x3F];
                    ++n8;
                }
                byte[] byArray4 = new byte[n8];
                System.arraycopy(byArray2, 0, byArray4, 0, n8);
                return byArray4;
            }
            byArray2[n5 - 2] = n6 == 2 ? byArray3[n7 & 0x3F] : 61;
            byArray2[n5 - 1] = 61;
        }
        return byArray2;
    }
}

