/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.codec;

import com.ccb.core.codec.Base62Codec;
import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IoUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class Base62 {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private static final Base62Codec CODEC = Base62Codec.createGmp();

    public static String encode(CharSequence charSequence) {
        return Base62.encode(charSequence, DEFAULT_CHARSET);
    }

    public static String encode(CharSequence charSequence, Charset charset) {
        return Base62.encode(StrUtil.bytes(charSequence, charset));
    }

    public static String encode(byte[] byArray) {
        return new String(CODEC.encode(byArray));
    }

    public static String encode(InputStream inputStream) {
        return Base62.encode(IoUtil.readBytes(inputStream));
    }

    public static String encode(File file) {
        return Base62.encode(FileUtil.readBytes(file));
    }

    public static String decodeStrGbk(CharSequence charSequence) {
        return Base62.decodeStr(charSequence, CharsetUtil.CHARSET_GBK);
    }

    public static String decodeStr(CharSequence charSequence) {
        return Base62.decodeStr(charSequence, DEFAULT_CHARSET);
    }

    public static String decodeStr(CharSequence charSequence, Charset charset) {
        return StrUtil.str(Base62.decode(charSequence), charset);
    }

    public static File decodeToFile(CharSequence charSequence, File file) {
        return FileUtil.writeBytes(Base62.decode(charSequence), file);
    }

    public static void decodeToStream(CharSequence charSequence, OutputStream outputStream, boolean bl) {
        IoUtil.write(outputStream, bl, Base62.decode(charSequence));
    }

    public static byte[] decode(CharSequence charSequence) {
        return Base62.decode(StrUtil.bytes(charSequence, DEFAULT_CHARSET));
    }

    public static byte[] decode(byte[] byArray) {
        return CODEC.decode(byArray);
    }
}

