/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.bean.copier;

import com.ccb.core.bean.BeanException;
import com.ccb.core.bean.BeanUtil;
import com.ccb.core.bean.DynaBean;
import com.ccb.core.bean.copier.CopyOptions;
import com.ccb.core.bean.copier.ValueProvider;
import com.ccb.core.bean.copier.provider.BeanValueProvider;
import com.ccb.core.bean.copier.provider.DynaBeanValueProvider;
import com.ccb.core.bean.copier.provider.MapValueProvider;
import com.ccb.core.collection.CollUtil;
import com.ccb.core.lang.copier.Copier;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.TypeUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class BeanCopier
implements Copier,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object source;
    private final Object dest;
    private final Type destType;
    private final CopyOptions copyOptions;

    public static BeanCopier create(Object object, Object object2, CopyOptions copyOptions) {
        return BeanCopier.create(object, object2, object2.getClass(), copyOptions);
    }

    public static BeanCopier create(Object object, Object object2, Type type, CopyOptions copyOptions) {
        return new BeanCopier(object, object2, type, copyOptions);
    }

    public BeanCopier(Object object, Object object2, Type type, CopyOptions copyOptions) {
        this.source = object;
        this.dest = object2;
        this.destType = type;
        this.copyOptions = copyOptions;
    }

    @Override
    public Object copy() {
        if (null != this.source) {
            if (this.source instanceof ValueProvider) {
                this.valueProviderToBean((ValueProvider)this.source, this.dest);
            } else if (this.source instanceof DynaBean) {
                this.valueProviderToBean(new DynaBeanValueProvider((DynaBean)this.source, this.copyOptions.ignoreError), this.dest);
            } else if (this.source instanceof Map) {
                if (this.dest instanceof Map) {
                    this.mapToMap((Map)this.source, (Map)this.dest);
                } else {
                    this.mapToBean((Map)this.source, this.dest);
                }
            } else if (this.dest instanceof Map) {
                this.beanToMap(this.source, (Map)this.dest);
            } else {
                this.beanToBean(this.source, this.dest);
            }
        }
        return this.dest;
    }

    private void beanToBean(Object object, Object object2) {
        this.valueProviderToBean(new BeanValueProvider(object, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), object2);
    }

    private void mapToBean(Map map, Object object) {
        this.valueProviderToBean(new MapValueProvider(map, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), object);
    }

    private void mapToMap(Map map, Map map2) {
        if (null != map2 && null != map) {
            map2.putAll(map);
        }
    }

    private void beanToMap(Object object, Map map) {
        HashSet hashSet = null != this.copyOptions.ignoreProperties ? CollUtil.newHashSet(this.copyOptions.ignoreProperties) : null;
        CopyOptions copyOptions = this.copyOptions;
        BeanUtil.descForEach(object.getClass(), propDesc -> {
            Object object2;
            if (!propDesc.isReadable(copyOptions.isTransientSupport())) {
                return;
            }
            String string = propDesc.getFieldName();
            if (CollUtil.contains((Collection)hashSet, string)) {
                return;
            }
            try {
                object2 = propDesc.getValue(object);
            }
            catch (Exception exception) {
                if (copyOptions.ignoreError) {
                    return;
                }
                throw new BeanException(exception, "Get value of [{}] error!", propDesc.getFieldName());
            }
            if (null == object2 && copyOptions.ignoreNullValue || object == object2) {
                return;
            }
            string = copyOptions.editFieldName(copyOptions.getMappedFieldName(string, false));
            map.put(string, object2);
        });
    }

    private void valueProviderToBean(ValueProvider valueProvider, Object object) {
        if (null == valueProvider) {
            return;
        }
        CopyOptions copyOptions = this.copyOptions;
        Class clazz = object.getClass();
        if (null != copyOptions.editable) {
            if (!copyOptions.editable.isInstance(object)) {
                throw new IllegalArgumentException(StrUtil.format((CharSequence)"Target class [{}] not assignable to Editable class [{}]", object.getClass().getName(), copyOptions.editable.getName()));
            }
            clazz = copyOptions.editable;
        }
        HashSet hashSet = null != copyOptions.ignoreProperties ? CollUtil.newHashSet(copyOptions.ignoreProperties) : null;
        BeanUtil.descForEach(clazz, propDesc -> {
            if (!propDesc.isWritable(this.copyOptions.isTransientSupport())) {
                return;
            }
            String string = propDesc.getFieldName();
            if (CollUtil.contains((Collection)hashSet, string)) {
                return;
            }
            String string2 = copyOptions.getMappedFieldName(string, true);
            if (!valueProvider.containsKey(string2)) {
                return;
            }
            Type type = TypeUtil.getActualType(this.destType, propDesc.getFieldType());
            Object object2 = valueProvider.value(string2, type);
            if (null == object2 && copyOptions.ignoreNullValue || object == object2) {
                return;
            }
            propDesc.setValue(object, object2, copyOptions.ignoreNullValue, copyOptions.ignoreError);
        });
    }
}

