/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.bean;

import com.ccb.core.bean.BeanDesc;
import com.ccb.core.bean.BeanDescCache;
import com.ccb.core.bean.BeanException;
import com.ccb.core.bean.BeanInfoCache;
import com.ccb.core.bean.BeanPath;
import com.ccb.core.bean.DynaBean;
import com.ccb.core.bean.copier.BeanCopier;
import com.ccb.core.bean.copier.CopyOptions;
import com.ccb.core.bean.copier.ValueProvider;
import com.ccb.core.collection.CollUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.lang.Editor;
import com.ccb.core.map.CaseInsensitiveMap;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.ModifierUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class BeanUtil {
    public static boolean isReadableBean(Class clazz) {
        return BeanUtil.hasGetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean isBean(Class clazz) {
        return BeanUtil.hasSetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean hasSetter(Class clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            Method[] methodArray;
            for (Method method : methodArray = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!ModifierUtil.isPublic(field) || ModifierUtil.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static DynaBean createDynaBean(Object object) {
        return new DynaBean(object);
    }

    public static PropertyEditor findEditor(Class clazz) {
        return PropertyEditorManager.findEditor(clazz);
    }

    public static BeanDesc getBeanDesc(Class clazz) {
        return BeanDescCache.INSTANCE.getBeanDesc(clazz, () -> new BeanDesc(clazz));
    }

    public static void descForEach(Class clazz, Consumer consumer) {
        BeanUtil.getBeanDesc(clazz).getProps().forEach(consumer);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            throw new BeanException(introspectionException);
        }
        return (PropertyDescriptor[])ArrayUtil.filter((Object[])beanInfo.getPropertyDescriptors(), propertyDescriptor -> false == "class".equals(propertyDescriptor.getName()));
    }

    public static Map getPropertyDescriptorMap(Class clazz, boolean bl) {
        return BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, bl, () -> BeanUtil.internalGetPropertyDescriptorMap(clazz, bl));
    }

    private static Map internalGetPropertyDescriptorMap(Class clazz, boolean bl) {
        PropertyDescriptor[] propertyDescriptorArray = BeanUtil.getPropertyDescriptors(clazz);
        Map map = bl ? new CaseInsensitiveMap(propertyDescriptorArray.length, 1.0f) : new HashMap(propertyDescriptorArray.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) {
        return BeanUtil.getPropertyDescriptor(clazz, string, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class clazz, String string, boolean bl) {
        Map map = BeanUtil.getPropertyDescriptorMap(clazz, bl);
        return null == map ? null : (PropertyDescriptor)map.get(string);
    }

    public static Object getFieldValue(Object object, String string) {
        if (null == object || null == string) {
            return null;
        }
        if (object instanceof Map) {
            return ((Map)object).get(string);
        }
        if (object instanceof Collection) {
            return CollUtil.get((Collection)object, Integer.parseInt(string));
        }
        if (ArrayUtil.isArray(object)) {
            return ArrayUtil.get(object, Integer.parseInt(string));
        }
        return ReflectUtil.getFieldValue(object, string);
    }

    public static void setFieldValue(Object object, String string, Object object2) {
        if (object instanceof Map) {
            ((Map)object).put(string, object2);
        } else if (object instanceof List) {
            CollUtil.setOrAppend((List)object, Convert.toInt(string), object2);
        } else if (ArrayUtil.isArray(object)) {
            ArrayUtil.setOrAppend(object, (int)Convert.toInt(string), object2);
        } else {
            ReflectUtil.setFieldValue(object, string, object2);
        }
    }

    public static Object getProperty(Object object, String string) {
        return BeanPath.create(string).get(object);
    }

    public static void setProperty(Object object, String string, Object object2) {
        BeanPath.create(string).set(object, object2);
    }

    public static Object mapToBean(Map map, Class clazz, boolean bl) {
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstanceIfPossible(clazz), bl);
    }

    public static Object mapToBeanIgnoreCase(Map map, Class clazz, boolean bl) {
        return BeanUtil.fillBeanWithMapIgnoreCase(map, ReflectUtil.newInstanceIfPossible(clazz), bl);
    }

    public static Object mapToBean(Map map, Class clazz, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstanceIfPossible(clazz), copyOptions);
    }

    public static Object mapToBean(Map map, Class clazz, boolean bl, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstanceIfPossible(clazz), bl, copyOptions);
    }

    public static Object fillBeanWithMap(Map map, Object object, boolean bl) {
        return BeanUtil.fillBeanWithMap(map, object, false, bl);
    }

    public static Object fillBeanWithMap(Map map, Object object, boolean bl, boolean bl2) {
        return BeanUtil.fillBeanWithMap(map, object, bl, CopyOptions.create().setIgnoreError(bl2));
    }

    public static Object fillBeanWithMapIgnoreCase(Map map, Object object, boolean bl) {
        return BeanUtil.fillBeanWithMap(map, object, CopyOptions.create().setIgnoreCase(true).setIgnoreError(bl));
    }

    public static Object fillBeanWithMap(Map map, Object object, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, object, false, copyOptions);
    }

    public static Object fillBeanWithMap(Map map, Object object, boolean bl, CopyOptions copyOptions) {
        if (MapUtil.isEmpty(map)) {
            return object;
        }
        if (bl) {
            map = MapUtil.toCamelCaseMap(map);
        }
        BeanUtil.copyProperties((Object)map, object, copyOptions);
        return object;
    }

    public static Object toBean(Object object, Class clazz) {
        return BeanUtil.toBean(object, clazz, null);
    }

    public static Object toBeanIgnoreError(Object object, Class clazz) {
        return BeanUtil.toBean(object, clazz, CopyOptions.create().setIgnoreError(true));
    }

    public static Object toBeanIgnoreCase(Object object, Class clazz, boolean bl) {
        return BeanUtil.toBean(object, clazz, CopyOptions.create().setIgnoreCase(true).setIgnoreError(bl));
    }

    public static Object toBean(Object object, Class clazz, CopyOptions copyOptions) {
        Object object2 = ReflectUtil.newInstanceIfPossible(clazz);
        BeanUtil.copyProperties(object, object2, copyOptions);
        return object2;
    }

    public static Object toBean(Class clazz, ValueProvider valueProvider, CopyOptions copyOptions) {
        return BeanUtil.fillBean(ReflectUtil.newInstanceIfPossible(clazz), valueProvider, copyOptions);
    }

    public static Object fillBean(Object object, ValueProvider valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return object;
        }
        return BeanCopier.create(valueProvider, object, copyOptions).copy();
    }

    public static Map beanToMap(Object object) {
        return BeanUtil.beanToMap(object, false, false);
    }

    public static Map beanToMap(Object object, boolean bl, boolean bl2) {
        return BeanUtil.beanToMap(object, new LinkedHashMap(), bl, bl2);
    }

    public static Map beanToMap(Object object, Map map, boolean bl, boolean bl2) {
        if (object == null) {
            return null;
        }
        return BeanUtil.beanToMap(object, map, bl2, string -> bl ? StrUtil.toUnderlineCase(string) : string);
    }

    public static Map beanToMap(Object object, Map map, boolean bl, Editor editor) {
        if (object == null) {
            return null;
        }
        return (Map)BeanCopier.create(object, map, CopyOptions.create().setIgnoreNullValue(bl).setFieldNameEditor(editor)).copy();
    }

    public static Object copyProperties(Object object, Class clazz, String ... stringArray) {
        Object object2 = ReflectUtil.newInstanceIfPossible(clazz);
        BeanUtil.copyProperties(object, object2, CopyOptions.create().setIgnoreProperties(stringArray));
        return object2;
    }

    public static void copyProperties(Object object, Object object2, String ... stringArray) {
        BeanUtil.copyProperties(object, object2, CopyOptions.create().setIgnoreProperties(stringArray));
    }

    public static void copyProperties(Object object, Object object2, boolean bl) {
        BeanCopier.create(object, object2, CopyOptions.create().setIgnoreCase(bl)).copy();
    }

    public static void copyProperties(Object object, Object object2, CopyOptions copyOptions) {
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        BeanCopier.create(object, object2, copyOptions).copy();
    }

    public static boolean isMatchName(Object object, String string, boolean bl) {
        return ClassUtil.getClassName(object, bl).equals(bl ? StrUtil.upperFirst(string) : string);
    }

    public static Object trimStrFields(Object object, String ... stringArray) {
        Field[] fieldArray;
        if (object == null) {
            return null;
        }
        for (Field field : fieldArray = ReflectUtil.getFields(object.getClass())) {
            String string;
            String string2;
            if (ModifierUtil.isStatic(field) || stringArray != null && ArrayUtil.containsIgnoreCase(stringArray, field.getName()) || !String.class.equals(field.getType()) || null == (string2 = (String)ReflectUtil.getFieldValue(object, field)) || string2.equals(string = StrUtil.trim(string2))) continue;
            ReflectUtil.setFieldValue(object, field, (Object)string);
        }
        return object;
    }

    public static boolean isNotEmpty(Object object, String ... stringArray) {
        return false == BeanUtil.isEmpty(object, stringArray);
    }

    public static boolean isEmpty(Object object, String ... stringArray) {
        if (null != object) {
            for (Field field : ReflectUtil.getFields(object.getClass())) {
                if (ModifierUtil.isStatic(field) || ArrayUtil.contains(stringArray, field.getName()) || null == ReflectUtil.getFieldValue(object, field)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNullField(Object object, String ... stringArray) {
        if (null == object) {
            return true;
        }
        for (Field field : ReflectUtil.getFields(object.getClass())) {
            if (ModifierUtil.isStatic(field) || ArrayUtil.contains(stringArray, field.getName()) || null != ReflectUtil.getFieldValue(object, field)) continue;
            return true;
        }
        return false;
    }
}

