/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification;

import java.util.Collections;
import java.util.List;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.apache.maven.shared.utils.StringUtils;

public class JarIdentificationAnalysis {
    private List exposers;

    public JarIdentification analyze(JarAnalyzer jarAnalyzer) {
        JarIdentification taxon = jarAnalyzer.getJarData().getJarIdentification();
        if (taxon != null) {
            return taxon;
        }
        taxon = new JarIdentification();
        for (JarIdentificationExposer exposer : this.exposers) {
            exposer.expose(taxon, jarAnalyzer);
        }
        this.normalize(taxon);
        jarAnalyzer.getJarData().setJarIdentification(taxon);
        return taxon;
    }

    private void normalize(JarIdentification taxon) {
        if (StringUtils.isEmpty((String)taxon.getGroupId())) {
            taxon.setGroupId(this.pickSmallest(taxon.getPotentialGroupIds()));
        }
        if (StringUtils.isEmpty((String)taxon.getArtifactId())) {
            taxon.setArtifactId(this.pickLargest(taxon.getPotentialArtifactIds()));
        }
        if (StringUtils.isEmpty((String)taxon.getVersion())) {
            taxon.setVersion(this.pickSmallest(taxon.getPotentialVersions()));
        }
        if (StringUtils.isEmpty((String)taxon.getName())) {
            taxon.setName(this.pickLargest(taxon.getPotentialNames()));
        }
        if (StringUtils.isEmpty((String)taxon.getVendor())) {
            taxon.setVendor(this.pickLargest(taxon.getPotentialVendors()));
        }
    }

    private String pickSmallest(List list) {
        String smallest = null;
        if (!list.isEmpty()) {
            int size = Integer.MAX_VALUE;
            for (String val : list) {
                if (!StringUtils.isNotEmpty((String)val) || val.length() >= size) continue;
                smallest = val;
                size = val.length();
            }
        }
        return smallest;
    }

    private String pickLargest(List list) {
        String largest = null;
        if (!list.isEmpty()) {
            int size = Integer.MIN_VALUE;
            for (String val : list) {
                if (!StringUtils.isNotEmpty((String)val) || val.length() <= size) continue;
                largest = val;
                size = val.length();
            }
        }
        return largest;
    }

    public void setExposers(List exposers) {
        this.exposers = Collections.unmodifiableList(exposers);
    }
}

