/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.resolver;

import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CumulativeScopeArtifactFilter
implements ArtifactFilter {
    private boolean compileScope;
    private boolean runtimeScope;
    private boolean testScope;
    private boolean providedScope;
    private boolean systemScope;

    CumulativeScopeArtifactFilter() {
    }

    CumulativeScopeArtifactFilter(String scope) {
        this.addScope(scope);
    }

    CumulativeScopeArtifactFilter(Collection<String> scopes) {
        if (scopes != null) {
            for (String scope : scopes) {
                this.addScope(scope);
            }
        }
    }

    void addScope(String scope) {
        if ("compile".equals(scope)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
        } else if ("runtime".equals(scope)) {
            this.compileScope = true;
            this.runtimeScope = true;
        } else if ("test".equals(scope)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = true;
        } else if ("provided".equals(scope)) {
            this.providedScope = true;
        }
    }

    public boolean include(Artifact artifact) {
        if ("compile".equals(artifact.getScope())) {
            return this.compileScope;
        }
        if ("runtime".equals(artifact.getScope())) {
            return this.runtimeScope;
        }
        if ("test".equals(artifact.getScope())) {
            return this.testScope;
        }
        if ("provided".equals(artifact.getScope())) {
            return this.providedScope;
        }
        if ("system".equals(artifact.getScope())) {
            return this.systemScope;
        }
        return true;
    }
}

