/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import org.apache.maven.plugins.invoker.InvokerProperties;
import org.apache.maven.plugins.invoker.SelectorUtils;

class Selector {
    static final int SELECTOR_MAVENVERSION = 1;
    static final int SELECTOR_JREVERSION = 2;
    static final int SELECTOR_OSFAMILY = 4;
    static final int SELECTOR_MULTI = 8;
    private final String actualMavenVersion;
    private final String actualJavaVersion;

    public Selector(String actualMavenVersion, String actualJavaVersion) {
        this.actualMavenVersion = actualMavenVersion;
        this.actualJavaVersion = actualJavaVersion;
    }

    public int getSelection(InvokerProperties invokerProperties) {
        if (!invokerProperties.isSelectorDefined(1)) {
            return this.getGlobal(invokerProperties);
        }
        for (int selectorIndex = 1; selectorIndex <= 1 || invokerProperties.isSelectorDefined(selectorIndex); ++selectorIndex) {
            int selection = 0;
            if (!SelectorUtils.isMavenVersion(invokerProperties.getMavenVersion(selectorIndex), this.actualMavenVersion)) {
                selection |= 1;
            }
            if (!SelectorUtils.isJreVersion(invokerProperties.getJreVersion(selectorIndex), this.actualJavaVersion)) {
                selection |= 2;
            }
            if (!SelectorUtils.isOsFamily(invokerProperties.getOsFamily(selectorIndex))) {
                selection |= 4;
            }
            if (selection != 0) continue;
            return 0;
        }
        return 8;
    }

    private int getGlobal(InvokerProperties invokerProperties) {
        int selection = 0;
        if (!SelectorUtils.isMavenVersion(invokerProperties.getMavenVersion(), this.actualMavenVersion)) {
            selection |= 1;
        }
        if (!SelectorUtils.isJreVersion(invokerProperties.getJreVersion(), this.actualJavaVersion.toString())) {
            selection |= 2;
        }
        if (!SelectorUtils.isOsFamily(invokerProperties.getOsFamily())) {
            selection |= 4;
        }
        return selection;
    }
}

