/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-compiler-plugin:2.3.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Compiler Plugin", 0);
        this.append(sb, "The Compiler Plugin is used to compile the sources of your project.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile".equals(this.goal)) {
            this.append(sb, "compiler:compile", 0);
            this.append(sb, "Compiles application sources", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "annotationProcessors", 2);
                this.append(sb, "Names of annotation processors to run. Only applies to JDK 1.6+ If not set, the default annotation processors discovery process applies.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerArgument", 2);
                this.append(sb, "Sets the unformatted argument string to be passed to the compiler if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerArguments", 2);
                this.append(sb, "Sets the arguments to be passed to the compiler (prepending a dash) if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerId (Default: javac)", 2);
                this.append(sb, "The compiler id of the compiler to use. See this guide for more information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerVersion", 2);
                this.append(sb, "Version of the compiler to use, ex. '1.3', '1.5', if fork is set to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: true)", 2);
                this.append(sb, "Set to true to include debugging information in the compiled class files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debuglevel", 2);
                this.append(sb, "Keyword list to be appended to the -g command-line switch. Legal values are none or a comma-separated list of the following keywords: lines, vars, and source. If debuglevel is not specified, by default, nothing will be appended to -g. If debug is not turned on, this attribute will be ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The -encoding argument for the Java compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of exclusion filters for the compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "executable", 2);
                this.append(sb, "Sets the executable of the compiler to use when fork is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Indicates whether the build will continue even if there are compilation errors; defaults to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Allows running the compiler in a separate process. If 'false' it uses the built in compiler, while if 'true' it will use an executable.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSourcesDirectory (Default: ${project.build.directory}/generated-sources/annotations)", 2);
                this.append(sb, "Specify where to place generated source files created by annotation processing. Only applies to JDK 1.6+\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of inclusion filters for the compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem", 2);
                this.append(sb, "Sets the maximum size, in megabytes, of the memory allocation pool, ex. '128', '128m' if fork is set to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "meminitial", 2);
                this.append(sb, "Initial size, in megabytes, of the memory allocation pool, ex. '64', '64m' if fork is set to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "optimize (Default: false)", 2);
                this.append(sb, "Set to true to optimize the compiled code using the compiler's optimization methods.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileName", 2);
                this.append(sb, "Sets the name of the output file when compiling a set of sources to a single file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "proc", 2);
                this.append(sb, "Sets whether annotation processing is performed or not. Only applies to JDK 1.6+ If not set, both compilation and annotation processing are performed at the same time.\n\nAllowed values are: none - no annotation processing is performed. only - only annotation processing is done, no compilation.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "showDeprecation (Default: false)", 2);
                this.append(sb, "Sets whether to show source locations where deprecated APIs are used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showWarnings (Default: false)", 2);
                this.append(sb, "Set to true to show compilation warnings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "source (Default: 1.5)", 2);
                this.append(sb, "The -source argument for the Java compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "Sets the granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "target (Default: 1.5)", 2);
                this.append(sb, "The -target argument for the Java compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Set to true to show messages about what the compiler is doing.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "compiler:help", 0);
            this.append(sb, "Display help information on maven-compiler-plugin.\nCall\n\u00a0\u00a0mvn\u00a0compiler:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "testCompile".equals(this.goal)) {
            this.append(sb, "compiler:testCompile", 0);
            this.append(sb, "Compiles application test sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "annotationProcessors", 2);
                this.append(sb, "Names of annotation processors to run. Only applies to JDK 1.6+ If not set, the default annotation processors discovery process applies.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerArgument", 2);
                this.append(sb, "Sets the unformatted argument string to be passed to the compiler if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerArguments", 2);
                this.append(sb, "Sets the arguments to be passed to the compiler (prepending a dash) if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerId (Default: javac)", 2);
                this.append(sb, "The compiler id of the compiler to use. See this guide for more information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerVersion", 2);
                this.append(sb, "Version of the compiler to use, ex. '1.3', '1.5', if fork is set to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: true)", 2);
                this.append(sb, "Set to true to include debugging information in the compiled class files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debuglevel", 2);
                this.append(sb, "Keyword list to be appended to the -g command-line switch. Legal values are none or a comma-separated list of the following keywords: lines, vars, and source. If debuglevel is not specified, by default, nothing will be appended to -g. If debug is not turned on, this attribute will be ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The -encoding argument for the Java compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "executable", 2);
                this.append(sb, "Sets the executable of the compiler to use when fork is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Indicates whether the build will continue even if there are compilation errors; defaults to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Allows running the compiler in a separate process. If 'false' it uses the built in compiler, while if 'true' it will use an executable.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedTestSourcesDirectory (Default: ${project.build.directory}/generated-sources/test-annotations)", 2);
                this.append(sb, "Specify where to place generated source files created by annotation processing. Only applies to JDK 1.6+\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem", 2);
                this.append(sb, "Sets the maximum size, in megabytes, of the memory allocation pool, ex. '128', '128m' if fork is set to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "meminitial", 2);
                this.append(sb, "Initial size, in megabytes, of the memory allocation pool, ex. '64', '64m' if fork is set to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "optimize (Default: false)", 2);
                this.append(sb, "Set to true to optimize the compiled code using the compiler's optimization methods.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileName", 2);
                this.append(sb, "Sets the name of the output file when compiling a set of sources to a single file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "proc", 2);
                this.append(sb, "Sets whether annotation processing is performed or not. Only applies to JDK 1.6+ If not set, both compilation and annotation processing are performed at the same time.\n\nAllowed values are: none - no annotation processing is performed. only - only annotation processing is done, no compilation.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "showDeprecation (Default: false)", 2);
                this.append(sb, "Sets whether to show source locations where deprecated APIs are used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showWarnings (Default: false)", 2);
                this.append(sb, "Set to true to show compilation warnings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "Set this to 'true' to bypass unit tests entirely. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "", 0);
                this.append(sb, "source (Default: 1.5)", 2);
                this.append(sb, "The -source argument for the Java compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "Sets the granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "target (Default: 1.5)", 2);
                this.append(sb, "The -target argument for the Java compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testCompilerArgument", 2);
                this.append(sb, "Sets the unformatted argument string to be passed to test compiler if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "testCompilerArguments", 2);
                this.append(sb, "Sets the arguments to be passed to test compiler (prepending a dash) if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "testExcludes", 2);
                this.append(sb, "A list of exclusion filters for the compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testIncludes", 2);
                this.append(sb, "A list of inclusion filters for the compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSource", 2);
                this.append(sb, "The -source argument for the test Java compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testTarget", 2);
                this.append(sb, "The -target argument for the test Java compiler.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Set to true to show messages about what the compiler is doing.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

