/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.checkstyle.AbstractCheckstyleReport;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorRequest;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="checkstyle", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CheckstyleReport
extends AbstractCheckstyleReport {
    private static final Map<String, String> FORMAT_TO_CONFIG_LOCATION;
    @Parameter(property="checkstyle.includes", defaultValue="**\\/*.java", required=true)
    private String includes;
    @Parameter(property="checkstyle.excludes")
    private String excludes;
    @Parameter(property="checkstyle.config.location", defaultValue="config/sun_checks.xml")
    private String configLocation;
    @Parameter(defaultValue="sun")
    private String format;
    @Parameter(property="checkstyle.properties.location")
    private String propertiesLocation;
    @Parameter
    private File propertiesFile;
    @Parameter
    private URL propertiesURL;
    @Parameter
    private String propertyExpansion;
    @Parameter(property="checkstyle.header.file", defaultValue="LICENSE.txt")
    private String headerLocation;
    @Parameter(defaultValue="${basedir}/LICENSE.txt")
    private File headerFile;
    @Parameter(defaultValue="${project.build.directory}/checkstyle-cachefile")
    private String cacheFile;
    @Parameter(property="checkstyle.suppressions.location")
    private String suppressionsLocation;
    @Parameter(property="checkstyle.suppression.expression", defaultValue="checkstyle.suppressions.file")
    private String suppressionsFileExpression;
    @Parameter
    private String suppressionsFile;
    @Parameter
    private String packageNamesLocation;
    @Parameter
    private String packageNamesFile;
    @Parameter(defaultValue="false")
    private boolean failsOnError;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDirectory;
    @Parameter(defaultValue="false")
    private boolean includeTestSourceDirectory;
    @Parameter(defaultValue="false")
    private boolean consoleOutput;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;

    protected MavenProject getProject() {
        return this.project;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        this.mergeDeprecatedInfo();
        super.executeReport(locale);
    }

    protected CheckstyleExecutorRequest createRequest() throws MavenReportException {
        CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
        request.setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setLog(this.getLog()).setProject(this.project).setSourceDirectory(this.sourceDirectory).setResources(this.resources).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectory(this.testSourceDirectory).setConfigLocation(this.configLocation).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation);
        return request;
    }

    public String getOutputName() {
        return "checkstyle";
    }

    public boolean canGenerateReport() {
        return !this.skip && (this.sourceDirectory.exists() || this.includeTestSourceDirectory && this.testSourceDirectory.exists());
    }

    private void mergeDeprecatedInfo() {
        File defaultHeaderFile;
        if ("config/sun_checks.xml".equals(this.configLocation) && !"sun".equals(this.format)) {
            this.configLocation = FORMAT_TO_CONFIG_LOCATION.get(this.format);
        }
        if (StringUtils.isEmpty((String)this.propertiesLocation)) {
            if (this.propertiesFile != null) {
                this.propertiesLocation = this.propertiesFile.getPath();
            } else if (this.propertiesURL != null) {
                this.propertiesLocation = this.propertiesURL.toExternalForm();
            }
        }
        if ("LICENSE.txt".equals(this.headerLocation) && !(defaultHeaderFile = new File(this.project.getBasedir(), "LICENSE.txt")).equals(this.headerFile)) {
            this.headerLocation = this.headerFile.getPath();
        }
        if (StringUtils.isEmpty((String)this.suppressionsLocation)) {
            this.suppressionsLocation = this.suppressionsFile;
        }
        if (StringUtils.isEmpty((String)this.packageNamesLocation)) {
            this.packageNamesLocation = this.packageNamesFile;
        }
    }

    static {
        HashMap<String, String> fmt2Cfg = new HashMap<String, String>();
        fmt2Cfg.put("sun", "config/sun_checks.xml");
        fmt2Cfg.put("turbine", "config/turbine_checks.xml");
        fmt2Cfg.put("avalon", "config/avalon_checks.xml");
        fmt2Cfg.put("maven", "config/maven_checks.xml");
        FORMAT_TO_CONFIG_LOCATION = Collections.unmodifiableMap(fmt2Cfg);
    }
}

