/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.task;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.task.ArchiverTask;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDirectoryTask
implements ArchiverTask {
    private final File directory;
    private List<String> includes;
    private List<String> excludes;
    private String outputDirectory;
    private boolean useDefaultExcludes = true;
    private int directoryMode = -1;
    private int fileMode = -1;

    public AddDirectoryTask(File directory) {
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException {
        block19: {
            if (".".equals(this.outputDirectory)) {
                this.outputDirectory = "";
            } else if ("..".equals(this.outputDirectory)) {
                throw new ArchiveCreationException("Cannot add source directory: " + this.directory + " to archive-path: " + this.outputDirectory + ". All paths must be within the archive root directory.");
            }
            int oldDirMode = archiver.getOverrideDirectoryMode();
            int oldFileMode = archiver.getOverrideFileMode();
            boolean fileModeSet = false;
            boolean dirModeSet = false;
            try {
                if (this.directoryMode != -1) {
                    archiver.setDirectoryMode(this.directoryMode);
                    dirModeSet = true;
                }
                if (this.fileMode != -1) {
                    archiver.setFileMode(this.fileMode);
                    fileModeSet = true;
                }
                if (!this.directory.exists()) break block19;
                ArrayList<Object> directoryExcludes = this.excludes != null && !this.excludes.isEmpty() ? new ArrayList<String>(this.excludes) : new ArrayList();
                try {
                    String[] includesArray = null;
                    if (this.includes != null && !this.includes.isEmpty()) {
                        includesArray = new String[this.includes.size()];
                        int i = 0;
                        for (String value : this.includes) {
                            if (value.startsWith("./") || value.startsWith(".\\")) {
                                value = value.substring(2);
                            }
                            if (value.startsWith("/") || value.startsWith("\\")) {
                                value = value.substring(1);
                            }
                            includesArray[i] = value;
                            ++i;
                        }
                    }
                    String[] excludesArray = new String[directoryExcludes.size()];
                    int i = 0;
                    for (String string : directoryExcludes) {
                        void var12_15;
                        void var12_18;
                        if (string.startsWith("./") || string.startsWith(".\\")) {
                            String string2 = string.substring(2);
                        }
                        if (var12_18.startsWith("/") || var12_18.startsWith("\\")) {
                            String string3 = var12_18.substring(1);
                        }
                        excludesArray[i] = var12_15;
                        ++i;
                    }
                    DefaultFileSet fs = new DefaultFileSet();
                    fs.setUsingDefaultExcludes(this.useDefaultExcludes);
                    fs.setPrefix(this.outputDirectory);
                    fs.setDirectory(this.directory);
                    fs.setIncludes(includesArray);
                    fs.setExcludes(excludesArray);
                    archiver.addFileSet((FileSet)fs);
                }
                catch (ArchiverException e) {
                    throw new ArchiveCreationException("Error adding directory to archive: " + e.getMessage(), e);
                }
            }
            finally {
                if (dirModeSet) {
                    archiver.setDirectoryMode(oldDirMode);
                }
                if (fileModeSet) {
                    archiver.setFileMode(oldFileMode);
                }
            }
        }
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setDirectoryMode(int directoryMode) {
        this.directoryMode = directoryMode;
    }

    public void setFileMode(int fileMode) {
        this.fileMode = fileMode;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

