/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.translation.advanced;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.translation.data.translation.advanced.TranslationAdvancedAbstract;
import org.wu.framework.translation.data.translation.api.TranslationAPI;
import org.wu.framework.translation.data.translation.endpoint.TransferDataFieldEndpoint;
import org.wu.framework.translation.data.translation.endpoint.TranslationFieldEndpoint;

public class TranslationAdvancedTarget
extends TranslationAdvancedAbstract {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranslationAdvancedTarget.class);
    private final List<TranslationAPI> translationAPIList;

    public TranslationAdvancedTarget(List<TranslationAPI> translationAPIList) {
        this.translationAPIList = translationAPIList;
    }

    @Override
    public boolean support(Object source) {
        return true;
    }

    @Override
    ConcurrentMap<? extends Class<? extends TranslationAPI>, ConcurrentMap<String, Object>> getTransformationTemplateMapsByItems(ConcurrentMap<Class<? extends TranslationAPI>, Set<Object>> classTranslationAPIListSourceConcurrentMap) {
        ConcurrentMap<Class, TranslationAPI> classTranslationAPIConcurrentMap = this.translationAPIList.stream().collect(Collectors.toConcurrentMap(translationAPI -> {
            if (Proxy.isProxyClass(translationAPI.getClass())) {
                return translationAPI.getClass().getInterfaces()[0];
            }
            return translationAPI.getClass();
        }, translationAPI -> translationAPI));
        ConcurrentMap<Class, ConcurrentMap> concurrentMapConcurrentMap = classTranslationAPIConcurrentMap.entrySet().stream().filter(translationAPIEntry -> classTranslationAPIListSourceConcurrentMap.containsKey(translationAPIEntry.getKey())).collect(Collectors.toConcurrentMap(Map.Entry::getKey, translationAPIEntry -> {
            Class TranslationAPIClass = (Class)translationAPIEntry.getKey();
            TranslationAPI translationAPI = (TranslationAPI)translationAPIEntry.getValue();
            Set sourceValues = (Set)classTranslationAPIListSourceConcurrentMap.get(TranslationAPIClass);
            try {
                return translationAPI.translation(sourceValues);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u65e0\u6cd5\u901a\u8fc7API\uff1a" + translationAPI + " \u83b7\u53d6\u6570\u636e ");
                return new ConcurrentHashMap();
            }
        }));
        return concurrentMapConcurrentMap;
    }

    @Override
    void doTransformation(Object source, List<TransferDataFieldEndpoint> transferDataFieldEndpointList) {
        Class<?> sourceClass = source.getClass();
        for (TransferDataFieldEndpoint transferDataFieldEndpoint : transferDataFieldEndpointList) {
            TranslationFieldEndpoint translationFieldEndpoint = transferDataFieldEndpoint.getTranslationFieldEndpoint();
            ConcurrentMap<String, Object> transferDataMap = transferDataFieldEndpoint.getTransferDataMap();
            if (!sourceClass.equals(translationFieldEndpoint.getTargetClass())) continue;
            Field targetField = translationFieldEndpoint.getTargetField();
            Field sourceField = translationFieldEndpoint.getSourceField();
            try {
                if (transferDataFieldEndpoint.getTranslationFieldEndpoint().getDeep().booleanValue()) {
                    Object targetFieldSource = targetField.get(source);
                    List<TransferDataFieldEndpoint> transferDataFieldEndpointList1 = transferDataFieldEndpoint.getTransferDataFieldEndpointList();
                    this.transformationObjects(transferDataFieldEndpointList1, targetFieldSource);
                    continue;
                }
                if (!ObjectUtils.isEmpty(transferDataMap)) {
                    Object o = sourceField.get(source);
                    if (ObjectUtils.isEmpty((Object)o)) {
                        return;
                    }
                    targetField.setAccessible(true);
                    Object targetValue = transferDataMap.getOrDefault(o.toString(), null);
                    targetField.set(source, targetValue);
                    continue;
                }
                log.warn("transferDataMap is null so i can not translation this field with name " + translationFieldEndpoint.getTargetClass().getName() + "#" + targetField.getName());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public int getOrder() {
        return 1024;
    }
}

