/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.wu.framework.translation.data.lock.ILock;

public class DefaultLock
implements ILock {
    ConcurrentHashMap<Object, Lock> LOCK_MAP = new ConcurrentHashMap(64);

    @Override
    public Lock lock(Object lockBean) {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        this.LOCK_MAP.putIfAbsent(lockBean, lock);
        return lock;
    }

    @Override
    public Lock lockInterruptibly(Object lockBean) throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        lock.lockInterruptibly();
        this.LOCK_MAP.putIfAbsent(lockBean, lock);
        return lock;
    }

    @Override
    public boolean tryLock(Object lockBean) {
        Lock lock = this.LOCK_MAP.get(lockBean);
        if (null != lock) {
            return lock.tryLock();
        }
        return false;
    }

    @Override
    public boolean tryLock(Object lockBean, long time, TimeUnit unit) throws InterruptedException {
        Lock lock = this.LOCK_MAP.get(lockBean);
        if (null != lock) {
            return lock.tryLock(time, unit);
        }
        return false;
    }

    @Override
    public void unlock(Object lockBean) {
        Lock lock = this.LOCK_MAP.get(lockBean);
        if (null != lock) {
            lock.unlock();
            this.LOCK_MAP.remove(lockBean);
        }
    }

    @Override
    public Condition newCondition() {
        return null;
    }
}

