/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.convert;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.utils.JsonUtils;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.translation.data.convert.AbstractLayerOperationConvert;
import org.wu.framework.translation.data.convert.LayerOperationConvert;
import org.wu.framework.translation.data.convert.LayerOperationConvertArrayByte;
import org.wu.framework.translation.data.convert.LayerOperationConvertBean;
import org.wu.framework.translation.data.convert.LayerOperationConvertDate;
import org.wu.framework.translation.data.convert.LayerOperationConvertDefault;
import org.wu.framework.translation.data.convert.LayerOperationConvertEnums;
import org.wu.framework.translation.data.convert.LayerOperationConvertLocalDateTime;

public class LayerOperationConvertList
extends AbstractLayerOperationConvert {
    private static final List<LayerOperationConvert> layerOperationConvertList = Arrays.asList(new LayerOperationConvertDefault(), new LayerOperationConvertDate(), new LayerOperationConvertLocalDateTime(), new LayerOperationConvertEnums(), new LayerOperationConvertList(), new LayerOperationConvertArrayByte(), new LayerOperationConvertBean());

    @Override
    public boolean support(Class<?> fieldType) {
        return Collection.class.isAssignableFrom(fieldType);
    }

    public List handler(Object fieldValue, Class fieldNormative) {
        try {
            List list = (List)JsonUtils.parseObject((String)fieldValue.toString(), (TypeReference)new TypeReference<List>(){});
            List objectList = list.stream().map(item -> {
                for (LayerOperationConvert layerOperationConvert : layerOperationConvertList) {
                    if (!layerOperationConvert.support(fieldNormative)) continue;
                    if (item != null && item.getClass().equals(String.class)) {
                        return layerOperationConvert.handler((Object)item.toString(), fieldNormative);
                    }
                    return layerOperationConvert.handler((Object)JsonUtils.toJsonString((Object)item), fieldNormative);
                }
                return null;
            }).collect(Collectors.toList());
            return objectList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List handler(Object fieldValue, Field field) {
        Class fieldNormative;
        if (ObjectUtils.isEmpty((Object)fieldValue)) {
            return null;
        }
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            fieldNormative = (Class)actualTypeArguments[0];
        } else {
            fieldNormative = field.getType();
        }
        return this.handler(fieldValue, fieldNormative);
    }
}

