/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.clazz.analyzing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.wu.framework.core.utils.FileUtil;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.translation.data.clazz.ClassType;
import org.wu.framework.translation.data.clazz.LazyClass;
import org.wu.framework.translation.data.clazz.LazyField;
import org.wu.framework.translation.data.clazz.analyzing.AbstractIClassAnalyzing;
import org.wu.framework.translation.data.clazz.analyzing.FieldIClassAnalyzing;
import org.wu.framework.translation.data.clazz.analyzing.IClassAnalyzing;

public final class ClazzIClassAnalyzing
extends AbstractIClassAnalyzing
implements IClassAnalyzing {
    private final List<String> java_key = Arrays.asList("public", "private", "final", "abstract", "class", "@interface", "interface");
    private final FieldIClassAnalyzing fieldIClassAnalyzing = new FieldIClassAnalyzing();

    @Override
    public boolean support(String classText) {
        return true;
    }

    @Override
    public LazyClass getLazyClass(Class<?> clazz) {
        LazyClass lazyClass = new LazyClass();
        String packageName = clazz.getPackage().getName();
        String readLocalSrcMainClassPath = FileUtil.readLocalSrcMainClassPath(clazz);
        boolean primitive = clazz.isPrimitive();
        String name = clazz.getName();
        ClassType classType = this.getClassType(clazz);
        Map lineContent = FileUtil.readFileLineContent((String)readLocalSrcMainClassPath);
        int totalLineNum = lineContent.size();
        List<String> importClasses = this.getImportClasses(lineContent);
        List<String> annotations = this.getClassAnnotation(lineContent);
        String classHeader = this.getClassHeader(lineContent);
        List<LazyField> lazyFields = this.fieldIClassAnalyzing.getFieldList(lineContent);
        lazyClass.setPackageName(packageName);
        lazyClass.setReadLocalSrcMainClassPath(readLocalSrcMainClassPath);
        lazyClass.setPublic(!primitive);
        lazyClass.setName(name);
        lazyClass.setClassType(classType);
        lazyClass.setTotalLineNum(totalLineNum);
        lazyClass.setLineContent(lineContent);
        lazyClass.setImportClasses(importClasses);
        lazyClass.setAnnotations(annotations);
        lazyClass.setClassHeader(classHeader);
        lazyClass.setFields(lazyFields);
        return lazyClass;
    }

    private String getClassHeader(Map<Integer, String> lineContent) {
        AtomicBoolean hit = new AtomicBoolean();
        int hitCodeLineIndex = 0;
        AtomicInteger hitLineNum = new AtomicInteger();
        StringBuilder classHeader = new StringBuilder();
        for (Map.Entry<Integer, String> integerStringEntry : lineContent.entrySet()) {
            Integer line = integerStringEntry.getKey();
            String content = integerStringEntry.getValue();
            String[] contentSplit = content.split(" ");
            AtomicBoolean[] jump = new AtomicBoolean[]{new AtomicBoolean(false)};
            for (int i = 0; i < contentSplit.length; ++i) {
                String code = contentSplit[i];
                if (ObjectUtils.isEmpty((Object)code) || code.startsWith("//")) continue;
                if (code.equals("/*") || code.startsWith("*")) {
                    jump[0].set(true);
                    continue;
                }
                if (jump[0].get() && code.equals("*/")) {
                    jump[0].set(false);
                    continue;
                }
                if (jump[0].get()) continue;
                if (code.equals("class") || code.equals("@interface") || code.equals("interface")) {
                    hitLineNum.set(line);
                    hitCodeLineIndex = i;
                    hit.set(true);
                }
                if (hit.get()) {
                    if (!code.endsWith("{")) continue;
                    for (int j = hitLineNum.get(); j < line; ++j) {
                        String hitLineCode = lineContent.get(i);
                        classHeader.append(hitLineCode);
                        classHeader.append(" ");
                    }
                    String lastLine = lineContent.get(hitLineNum.get());
                    String[] split = lastLine.split(" ");
                    for (int i1 = hitCodeLineIndex; i1 <= i; ++i1) {
                        classHeader.append(split[i1]);
                        classHeader.append(" ");
                    }
                    return classHeader.toString();
                }
                if (this.java_key.contains(code)) {
                    classHeader.append(code);
                    classHeader.append(" ");
                    continue;
                }
                classHeader = new StringBuilder();
            }
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u83b7\u53d6class \u5934\u90e8\u4fe1\u606f");
    }

    protected ClassType getClassType(Class<?> clazz) {
        boolean anEnum = clazz.isEnum();
        boolean annotation = clazz.isAnnotation();
        boolean anInterface = clazz.isInterface();
        if (anEnum) {
            return ClassType.ENUM;
        }
        if (annotation) {
            return ClassType.ANNOTATION;
        }
        if (anInterface) {
            return ClassType.INTERFACE;
        }
        return ClassType.CLASS;
    }

    private List<String> getClassAnnotation(Map<Integer, String> lineContent) {
        ArrayList<String> annotationList = new ArrayList<String>();
        lineContent.forEach((line, content) -> {
            List<String> lineAnnotations = this.getLineAnnotations((String)content);
            annotationList.addAll(lineAnnotations);
        });
        return annotationList;
    }

    private List<String> getLineAnnotations(String lineContent) {
        ArrayList<String> annotationList = new ArrayList<String>();
        String[] contentSplit = lineContent.split(" ");
        boolean hitNum = false;
        int startIndex = 0;
        boolean jump = false;
        for (int i = 0; i < contentSplit.length; ++i) {
            String content = contentSplit[i];
            if (ObjectUtils.isEmpty((Object)content) || content.startsWith("//")) continue;
            if (content.equals("/*") || content.startsWith("*")) {
                jump = true;
                continue;
            }
            if (jump && content.equals("*/")) {
                jump = false;
                continue;
            }
            if (jump) continue;
            if (content.startsWith("@") && i == contentSplit.length - 1) {
                annotationList.add(content);
            }
            if (content.startsWith("@")) {
                hitNum = true;
                startIndex = i;
                continue;
            }
            if (!hitNum || !content.startsWith("public") && !content.startsWith("private") && !content.startsWith("class") && !content.startsWith("protected")) continue;
            hitNum = false;
            StringBuilder hitLineCode = new StringBuilder();
            for (int hitIndex = startIndex; hitIndex <= i; ++hitIndex) {
                String hitLineCodePart = contentSplit[hitIndex];
                hitLineCode.append(hitLineCodePart);
                hitLineCode.append(" ");
            }
            annotationList.add(hitLineCode.toString());
        }
        return annotationList;
    }

    private List<String> getImportClasses(Map<Integer, String> lineContent) {
        ArrayList<String> importClasses = new ArrayList<String>();
        lineContent.forEach((line, content) -> {
            List<String> importClasses1 = this.getLineImportClasses((String)content);
            importClasses.addAll(importClasses1);
        });
        return importClasses;
    }

    private List<String> getLineImportClasses(String lineContent) {
        ArrayList<String> importClasses = new ArrayList<String>();
        String[] contentSplit = lineContent.split(" ");
        boolean hitNum = false;
        int startIndex = 0;
        boolean jump = false;
        for (int i = 0; i < contentSplit.length; ++i) {
            String content = contentSplit[i];
            if (ObjectUtils.isEmpty((Object)content) || content.startsWith("//") || content.startsWith("*")) continue;
            if (content.equals("/*")) {
                jump = true;
                continue;
            }
            if (jump && content.equals("*/")) {
                jump = false;
                continue;
            }
            if (jump) continue;
            if (content.equals("import")) {
                hitNum = true;
                startIndex = i;
                continue;
            }
            if (!hitNum || !content.contains(";")) continue;
            hitNum = false;
            StringBuilder hitLineCode = new StringBuilder();
            for (int hitIndex = startIndex; hitIndex <= i; ++hitIndex) {
                String hitLineCodePart = contentSplit[hitIndex];
                hitLineCode.append(hitLineCodePart);
                hitLineCode.append(" ");
            }
            importClasses.add(hitLineCode.toString());
        }
        return importClasses;
    }
}

