/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.translation.advanced;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.translation.data.translation.TranslationBean;
import org.wu.framework.translation.data.translation.TranslationField;
import org.wu.framework.translation.data.translation.TranslationLayer;
import org.wu.framework.translation.data.translation.advanced.TranslationAdvanced;
import org.wu.framework.translation.data.translation.api.TranslationAPI;
import org.wu.framework.translation.data.translation.endpoint.TransferDataFieldEndpoint;
import org.wu.framework.translation.data.translation.endpoint.TranslationClassEndpoint;
import org.wu.framework.translation.data.translation.endpoint.TranslationFieldEndpoint;

public abstract class TranslationAdvancedAbstract
implements TranslationAdvanced {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranslationAdvancedAbstract.class);

    public List<TransferDataFieldEndpoint> transformationTemplateMaps(Object ... sources) {
        List<TranslationClassEndpoint> translationClassEndpointList = this.sourceClassEndpointList(sources);
        this.sourceValueObjects(translationClassEndpointList, sources);
        ArrayList<TransferDataFieldEndpoint> transferDataFieldEndpointList = new ArrayList();
        try {
            transferDataFieldEndpointList = this.getTransformationTemplateMapsByRpc(translationClassEndpointList, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("fail to init api:{}", (Object)e.getMessage());
        }
        return transferDataFieldEndpointList;
    }

    private List<TransferDataFieldEndpoint> getTransformationTemplateMapsByRpc(List<TranslationClassEndpoint> translationClassEndpointList, boolean order) {
        ConcurrentMap<Class<? extends TranslationAPI>, Set<Object>> sourceValuesByTranslationClassEndpointList = this.getSourceValuesByTranslationClassEndpointList(translationClassEndpointList, null);
        ConcurrentMap<? extends Class<? extends TranslationAPI>, ConcurrentMap<String, Object>> transformationTemplateMapsByItems = this.getTransformationTemplateMapsByItems(sourceValuesByTranslationClassEndpointList);
        return this.setTransferDataFieldEndpointList(translationClassEndpointList, transformationTemplateMapsByItems, null);
    }

    private List<TransferDataFieldEndpoint> setTransferDataFieldEndpointList(List<TranslationClassEndpoint> translationClassEndpointList, ConcurrentMap<? extends Class<? extends TranslationAPI>, ConcurrentMap<String, Object>> transformationTemplateMapsByItems, List<TransferDataFieldEndpoint> transferDataFieldEndpointList) {
        if (ObjectUtils.isEmpty(transferDataFieldEndpointList)) {
            transferDataFieldEndpointList = new ArrayList<TransferDataFieldEndpoint>();
        }
        for (TranslationClassEndpoint translationClassEndpoint : translationClassEndpointList) {
            Class<?> translationClass = translationClassEndpoint.getTranslationClass();
            List<TranslationFieldEndpoint> translationFieldEndpointList = translationClassEndpoint.getTranslationFieldEndpointList();
            for (TranslationFieldEndpoint translationFieldEndpoint : translationFieldEndpointList) {
                TransferDataFieldEndpoint transferDataFieldEndpoint = new TransferDataFieldEndpoint();
                transferDataFieldEndpoint.setTranslationFieldEndpoint(translationFieldEndpoint);
                if (translationFieldEndpoint.getDeep().booleanValue()) {
                    List<TransferDataFieldEndpoint> transferDataFieldEndpointList1 = this.setTransferDataFieldEndpointList(translationFieldEndpoint.getMultipleTranslationClassEndpointList(), transformationTemplateMapsByItems, null);
                    transferDataFieldEndpoint.setTransferDataFieldEndpointList(transferDataFieldEndpointList1);
                    transferDataFieldEndpointList.add(transferDataFieldEndpoint);
                    continue;
                }
                Class<? extends TranslationAPI> smartConvertAdapter = translationFieldEndpoint.getTranslationAPI();
                transferDataFieldEndpoint.setTransferDataMap(transformationTemplateMapsByItems.getOrDefault(smartConvertAdapter, null));
                transferDataFieldEndpointList.add(transferDataFieldEndpoint);
            }
        }
        return transferDataFieldEndpointList;
    }

    private ConcurrentMap<Class<? extends TranslationAPI>, Set<Object>> getSourceValuesByTranslationClassEndpointList(List<TranslationClassEndpoint> translationClassEndpointList, ConcurrentMap<Class<? extends TranslationAPI>, Set<Object>> classListConcurrentMap) {
        if (ObjectUtils.isEmpty(classListConcurrentMap)) {
            classListConcurrentMap = new ConcurrentHashMap<Class<? extends TranslationAPI>, Set<Object>>();
        }
        for (TranslationClassEndpoint translationClassEndpoint : translationClassEndpointList) {
            for (TranslationFieldEndpoint translationFieldEndpoint : translationClassEndpoint.getTranslationFieldEndpointList()) {
                Boolean deep = translationFieldEndpoint.getDeep();
                if (deep.booleanValue()) {
                    ConcurrentMap<Class<? extends TranslationAPI>, Set<Object>> sourceValuesByTranslationClassEndpointList = this.getSourceValuesByTranslationClassEndpointList(translationFieldEndpoint.getMultipleTranslationClassEndpointList(), classListConcurrentMap);
                    for (Map.Entry classSetEntry : sourceValuesByTranslationClassEndpointList.entrySet()) {
                        Class translationAPIClass = (Class)classSetEntry.getKey();
                        Set value = (Set)classSetEntry.getValue();
                        Set<Object> objects = classListConcurrentMap.getOrDefault(translationAPIClass, value);
                        objects.addAll(value);
                        classListConcurrentMap.put(translationAPIClass, objects);
                    }
                    classListConcurrentMap.putAll(sourceValuesByTranslationClassEndpointList);
                    continue;
                }
                Set<Object> sourceValues = translationFieldEndpoint.getSourceValues();
                Class<? extends TranslationAPI> translationAPI = translationFieldEndpoint.getTranslationAPI();
                Set<Object> orDefault = classListConcurrentMap.getOrDefault(translationAPI, sourceValues);
                orDefault.addAll(sourceValues);
                classListConcurrentMap.put(translationAPI, orDefault);
            }
        }
        return classListConcurrentMap;
    }

    abstract ConcurrentMap<? extends Class<? extends TranslationAPI>, ConcurrentMap<String, Object>> getTransformationTemplateMapsByItems(ConcurrentMap<Class<? extends TranslationAPI>, Set<Object>> var1);

    public void sourceValueObjects(List<TranslationClassEndpoint> translationClassEndpointList, Object ... sources) {
        for (Object source : sources) {
            if (source == null) continue;
            if (Collection.class.isAssignableFrom(source.getClass())) {
                this.sourceValueList(translationClassEndpointList, (Collection)source);
                continue;
            }
            this.sourceValueOne(translationClassEndpointList, source);
        }
    }

    public void sourceValueList(List<TranslationClassEndpoint> translationClassEndpointList, Collection<?> sources) {
        for (Object source : sources) {
            if (Collection.class.isAssignableFrom(source.getClass())) {
                this.sourceValueList(translationClassEndpointList, (Collection)source);
                continue;
            }
            this.sourceValueOne(translationClassEndpointList, source);
        }
    }

    public void sourceValueOne(List<TranslationClassEndpoint> translationClassEndpointList, Object source) {
        ConcurrentMap translationClassEndpointConcurrentMap = translationClassEndpointList.stream().collect(Collectors.toConcurrentMap(TranslationClassEndpoint::getTranslationClass, Function.identity()));
        if (translationClassEndpointConcurrentMap.containsKey(source.getClass())) {
            TranslationClassEndpoint translationClassEndpoint = (TranslationClassEndpoint)translationClassEndpointConcurrentMap.get(source.getClass());
            translationClassEndpoint.getTranslationFieldEndpointList().forEach(translationFieldEndpoint -> {
                Object o;
                Field sourceField = translationFieldEndpoint.getSourceField();
                try {
                    if (Boolean.TRUE.equals(translationFieldEndpoint.getDeep())) {
                        Field targetField = translationFieldEndpoint.getTargetField();
                        targetField.setAccessible(true);
                        Object targetValue = targetField.get(source);
                        List<TranslationClassEndpoint> multipleTranslationClassEndpointList = translationFieldEndpoint.getMultipleTranslationClassEndpointList();
                        this.sourceValueObjects(multipleTranslationClassEndpointList, targetValue);
                        return;
                    }
                    sourceField.setAccessible(true);
                    o = sourceField.get(source);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                translationFieldEndpoint.getSourceValues().add(o);
            });
        }
    }

    public List<TranslationClassEndpoint> sourceClassEndpointList(Object ... sources) {
        List sourceClassList = Arrays.stream(Arrays.stream(sources).filter(o -> !ObjectUtils.isEmpty((Object)o)).map(o -> {
            if (o instanceof Collection && !ObjectUtils.isEmpty((Object)o)) {
                return ((Collection)o).iterator().next().getClass();
            }
            return o.getClass();
        }).toArray(Class[]::new)).collect(Collectors.toList());
        ArrayList<TranslationClassEndpoint> translationClassEndpointList = new ArrayList<TranslationClassEndpoint>();
        for (Class sourceClass : sourceClassList) {
            List<TranslationClassEndpoint> classEndpointList = this.doSourceClassEndpoint(null, sourceClass);
            translationClassEndpointList.addAll(classEndpointList);
        }
        return translationClassEndpointList;
    }

    public List<TranslationClassEndpoint> doSourceClassEndpoint(List<TranslationClassEndpoint> translationClassEndpointList, Class<?> sourceClass) {
        if (null == translationClassEndpointList) {
            translationClassEndpointList = new ArrayList<TranslationClassEndpoint>();
        }
        Field[] fields = sourceClass.getDeclaredFields();
        ConcurrentMap fieldConcurrentMap = Arrays.stream(fields).collect(Collectors.toConcurrentMap(Field::getName, Function.identity()));
        TranslationClassEndpoint translationClassEndpoint = new TranslationClassEndpoint();
        translationClassEndpoint.setTranslationClass(sourceClass);
        if (translationClassEndpointList.contains(translationClassEndpoint)) {
            return translationClassEndpointList;
        }
        List<TranslationFieldEndpoint> translationFieldEndpointList = Arrays.stream(fields).filter(this::isTranslationLayer).map(field -> {
            TranslationFieldEndpoint translationFieldEndpoint = new TranslationFieldEndpoint();
            if (this.isFieldSupportDeep((Field)field)) {
                Class fieldType = field.getType();
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)genericType;
                    Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                    Type rawType = parameterizedType.getRawType();
                    if (Collection.class.isAssignableFrom((Class)rawType)) {
                        Class actualTypeArgument;
                        fieldType = actualTypeArgument = (Class)actualTypeArguments[0];
                    }
                    if (rawType instanceof Map) {
                        Type mapKeyType = actualTypeArguments[0];
                        Type type = actualTypeArguments[1];
                    }
                }
                translationFieldEndpoint.setTargetClass(sourceClass);
                translationFieldEndpoint.setDeep(true);
                translationFieldEndpoint.setTransferDataName(field.getName());
                translationFieldEndpoint.setTranslationTargetName(field.getName());
                translationFieldEndpoint.setTargetField((Field)field);
                List<TranslationClassEndpoint> translationClassEndpoints = this.doSourceClassEndpoint(null, fieldType);
                translationFieldEndpoint.getMultipleTranslationClassEndpointList().addAll(translationClassEndpoints);
            } else if (this.isFieldConvert((Field)field)) {
                translationFieldEndpoint = this.getTranslationFieldEndpoint((Field)field);
                translationFieldEndpoint.setDeep(false);
                if (ObjectUtils.isEmpty((Object)translationFieldEndpoint)) {
                    return null;
                }
                translationFieldEndpoint.setTargetClass(sourceClass);
                String translationSourceName = translationFieldEndpoint.getTranslationSourceName();
                if (fieldConcurrentMap.containsKey(translationSourceName)) {
                    Field sourceField = (Field)fieldConcurrentMap.get(translationSourceName);
                    translationFieldEndpoint.setSourceField(sourceField);
                } else {
                    throw new RuntimeException("\u914d\u7f6e\u9519\u8bef\u65e0\u6cd5\u4ece\u5f53\u524dclass: " + sourceClass.getName() + " \u627e\u5230\u539f\u59cb\u6570\u636e\u5b57\u6bb5: " + translationSourceName);
                }
            }
            return translationFieldEndpoint;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        translationClassEndpoint.setTranslationFieldEndpointList(translationFieldEndpointList);
        translationClassEndpointList.add(translationClassEndpoint);
        return translationClassEndpointList;
    }

    public boolean isFieldSupportDeep(Field field) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, TranslationBean.class);
    }

    private List<TranslationClassEndpoint> getSourceTranslationFieldEndpointList(List<Class<?>> classList) {
        ArrayList<TranslationClassEndpoint> translationClassEndpointList = new ArrayList<TranslationClassEndpoint>();
        if (ObjectUtils.isEmpty(classList)) {
            return translationClassEndpointList;
        }
        for (Class<?> aClass : classList) {
            Field[] fields = aClass.getDeclaredFields();
            ConcurrentMap fieldConcurrentMap = Arrays.stream(fields).collect(Collectors.toConcurrentMap(Field::getName, Function.identity()));
            TranslationClassEndpoint translationClassEndpoint = new TranslationClassEndpoint();
            translationClassEndpoint.setTranslationClass(aClass);
            if (translationClassEndpointList.contains(translationClassEndpoint)) continue;
            List<TranslationFieldEndpoint> translationFieldEndpointList = Arrays.stream(fields).filter(this::isFieldConvert).map(field -> {
                TranslationFieldEndpoint translationFieldEndpoint = this.getTranslationFieldEndpoint((Field)field);
                if (ObjectUtils.isEmpty((Object)translationFieldEndpoint)) {
                    return null;
                }
                translationFieldEndpoint.setTargetClass(aClass);
                String translationSourceName = translationFieldEndpoint.getTranslationSourceName();
                if (!fieldConcurrentMap.containsKey(translationSourceName)) {
                    throw new RuntimeException("\u914d\u7f6e\u9519\u8bef\u65e0\u6cd5\u4ece\u5f53\u524dclass: " + aClass.getName() + " \u627e\u5230\u539f\u59cb\u6570\u636e\u5b57\u6bb5: " + translationSourceName);
                }
                Field sourceField = (Field)fieldConcurrentMap.get(translationSourceName);
                translationFieldEndpoint.setSourceField(sourceField);
                if (this.isFieldConvert((Field)field)) {
                    translationFieldEndpoint.setDeep(false);
                } else if (this.isFieldSupportDeep((Field)field)) {
                    translationFieldEndpoint.setDeep(true);
                }
                return translationFieldEndpoint;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            List deepFieldEndpointList = Arrays.stream(fields).filter(this::isFieldSupportDeep).map(field -> {
                Class<?> fieldType = field.getType();
                TranslationFieldEndpoint translationFieldEndpoint = new TranslationFieldEndpoint();
                translationFieldEndpoint.setTargetClass(aClass);
                translationFieldEndpoint.setDeep(true);
                translationFieldEndpoint.setTransferDataName(field.getName());
                translationFieldEndpoint.setTranslationTargetName(field.getName());
                translationFieldEndpoint.setTargetField((Field)field);
                return translationFieldEndpoint;
            }).collect(Collectors.toList());
            translationFieldEndpointList.addAll(deepFieldEndpointList);
            translationClassEndpoint.setTranslationFieldEndpointList(translationFieldEndpointList);
            translationClassEndpointList.add(translationClassEndpoint);
        }
        return translationClassEndpointList;
    }

    public boolean isTranslationLayer(Field field) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, TranslationLayer.class);
    }

    public boolean isFieldConvert(Field field) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, TranslationField.class);
    }

    public TranslationFieldEndpoint getTranslationFieldEndpoint(Field field) {
        TranslationField translationField = (TranslationField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TranslationField.class);
        TranslationFieldEndpoint translationFieldEndpoint = new TranslationFieldEndpoint();
        if (null == translationField) {
            return null;
        }
        translationFieldEndpoint.setDefaultValue(translationField.defaultValue());
        translationFieldEndpoint.setTranslationSourceName(translationField.translationSourceName());
        translationFieldEndpoint.setTransferDataName(ObjectUtils.isEmpty((Object)translationField.transferDataName()) ? field.getName() : translationField.transferDataName());
        translationFieldEndpoint.setTranslationTargetName(ObjectUtils.isEmpty((Object)translationField.translationTargetName()) ? field.getName() : translationField.translationTargetName());
        translationFieldEndpoint.setTranslationTargetType(translationField.translationTargetType());
        translationFieldEndpoint.setTranslationAPI(translationField.translationAPI());
        translationFieldEndpoint.setConvertSplitCharacter(translationField.convertSplitCharacter());
        translationFieldEndpoint.setTargetField(field);
        return translationFieldEndpoint;
    }

    public void transformationObjects(List<TransferDataFieldEndpoint> transferDataEndpointConcurrentMap, Object ... sources) {
        if (ObjectUtils.isEmpty((Object)sources)) {
            return;
        }
        for (Object source : sources) {
            if (ObjectUtils.isEmpty((Object)source)) continue;
            if (source instanceof Collection) {
                this.transformationCollection(transferDataEndpointConcurrentMap, (Collection)source);
                continue;
            }
            this.doTransformation(source, transferDataEndpointConcurrentMap);
        }
    }

    protected void transformationCollection(List<TransferDataFieldEndpoint> transferDataEndpointConcurrentMap, Collection<?> collection) {
        for (Object o : collection) {
            if (o instanceof Collection) {
                this.transformationCollection(transferDataEndpointConcurrentMap, (Collection)o);
                continue;
            }
            this.doTransformation(o, transferDataEndpointConcurrentMap);
        }
    }

    abstract void doTransformation(Object var1, List<TransferDataFieldEndpoint> var2);

    @Override
    public void transformation(Object source) {
        List<TransferDataFieldEndpoint> transferDataEndpointConcurrentMap = this.transformationTemplateMaps(source);
        this.transformationObjects(transferDataEndpointConcurrentMap, source);
    }
}

