/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.encryption.convert;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.translation.data.encryption.EncryptionField;
import org.wu.framework.translation.data.encryption.EncryptionFieldBean;
import org.wu.framework.translation.data.encryption.adapter.EncryptionDecryptionAdapter;
import org.wu.framework.translation.data.encryption.convert.AbstractConvertEncryptionDecryption;
import org.wu.framework.translation.data.encryption.enums.EncryptionDecryptionEnum;
import org.wu.framework.translation.data.encryption.enums.EncryptionDecryptionTypeEnum;

public class DefaultConvertEncryptionDecryption
extends AbstractConvertEncryptionDecryption {
    private final EncryptionDecryptionAdapter encryptionDecryptionAdapter;

    public DefaultConvertEncryptionDecryption(EncryptionDecryptionAdapter encryptionDecryptionAdapter) {
        this.encryptionDecryptionAdapter = encryptionDecryptionAdapter;
    }

    @Override
    public void transformationField(EncryptionDecryptionTypeEnum encryptionDecryptionTypeEnum, Object object) {
        Field[] clazzDeclaredFields;
        Class<?> clazz = object.getClass();
        for (Field field : clazzDeclaredFields = clazz.getDeclaredFields()) {
            try {
                Object encryption;
                field.setAccessible(true);
                Object fieldVal = field.get(object);
                EncryptionFieldBean convertFieldBean = field.getAnnotation(EncryptionFieldBean.class);
                if (!ObjectUtils.isEmpty((Object)convertFieldBean)) {
                    this.transformationObjects(encryptionDecryptionTypeEnum, fieldVal);
                    continue;
                }
                final EncryptionField encryptionField = (EncryptionField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, EncryptionField.class);
                if (ObjectUtils.isEmpty((Object)encryptionField) || ObjectUtils.isEmpty((Object)fieldVal) || null == this.encryptionDecryptionAdapter) continue;
                EncryptionDecryptionEnum encryptionDecryptionEnum = encryptionField.encryptionDecryptionType();
                Supplier supplier = null;
                if (EncryptionDecryptionEnum.AES.equals((Object)encryptionDecryptionEnum)) {
                    supplier = new Supplier(){

                        public Object get() {
                            return encryptionField.aesKey();
                        }
                    };
                } else if (EncryptionDecryptionEnum.RSA.equals((Object)encryptionDecryptionEnum)) {
                    supplier = new Supplier(){

                        public Object get() {
                            HashMap<String, String> keyMap = new HashMap<String, String>(2);
                            keyMap.put("PUBLIC_KEY", encryptionField.rsaPublicKey());
                            keyMap.put("PRIVATE_KEY", encryptionField.rsaPrivateKey());
                            return keyMap;
                        }
                    };
                }
                if (EncryptionDecryptionTypeEnum.ENCRYPTION.equals((Object)encryptionDecryptionTypeEnum)) {
                    encryption = this.encryptionDecryptionAdapter.encryption(encryptionDecryptionEnum, fieldVal, supplier);
                    field.set(object, encryption.toString());
                    continue;
                }
                encryption = this.encryptionDecryptionAdapter.decryption(encryptionDecryptionEnum, fieldVal, supplier);
                field.set(object, encryption.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean support(Object source) {
        return !Objects.isNull(source);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

