/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.translation.data.LayerData;
import org.wu.framework.translation.data.SmartMark;

public interface LayerDataAnalyzeAdapter {
    default public List<List> extractData(List<List> extractList, Object ... objects) {
        if (extractList == null) {
            extractList = new ArrayList<List>();
        }
        for (Object object : objects) {
            Class<?> aClass = object.getClass();
            LayerData lazyTable = (LayerData)AnnotatedElementUtils.findMergedAnnotation(aClass, LayerData.class);
            if (null == lazyTable || !lazyTable.dataDrillDown()) {
                extractList.add(Collections.singletonList(object));
                continue;
            }
            for (Field field : aClass.getDeclaredFields()) {
                field.setAccessible(true);
                SmartMark smartMarkField = (SmartMark)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, SmartMark.class);
                if (null == smartMarkField) continue;
                Class<?> fieldType = field.getType();
                Object o = null;
                try {
                    o = field.get(object);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (null == o) continue;
                if (Iterable.class.isAssignableFrom(fieldType)) {
                    extractList.add((List)o);
                    continue;
                }
                this.extractData(extractList, o);
            }
        }
        return extractList;
    }
}

