/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.spring.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;

public class LazyAopProxyUtils {
    public static Object getTarget(Object proxy) throws Exception {
        if (proxy instanceof SpringProxy) {
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                return LazyAopProxyUtils.getJdkDynamicProxyTargetObject(proxy);
            }
            if (AopUtils.isCglibProxy((Object)proxy)) {
                return LazyAopProxyUtils.getCglibProxyTargetObject(proxy);
            }
            return proxy;
        }
        if (Proxy.isProxyClass(proxy.getClass())) {
            return LazyAopProxyUtils.getJdkDynamicProxyTargetObject(proxy);
        }
        if (proxy.getClass().getName().contains("$$")) {
            return LazyAopProxyUtils.getCglibProxyTargetObject(proxy);
        }
        return proxy;
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }

    public static Class<?> getTargetClass(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy == null ? null : proxy.getClass();
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return LazyAopProxyUtils.getJdkDynamicProxyTargetObjectClass(proxy);
        }
        return LazyAopProxyUtils.getCglibProxyTargetObjectClass(proxy);
    }

    private static Class<?> getCglibProxyTargetObjectClass(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Class[] proxiedInterfaces = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getProxiedInterfaces();
        return proxiedInterfaces[0];
    }

    private static Class<?> getJdkDynamicProxyTargetObjectClass(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Class[] proxiedInterfaces = ((ProxyFactory)advised.get(aopProxy)).getProxiedInterfaces();
        return proxiedInterfaces[0];
    }
}

