/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.inner.lazy.orm.spring.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.TypeFilter;
import org.wu.framework.core.utils.ObjectUtils;

public final class ScanClassUtil {
    public static List<Class<?>> scanClass(String packagePath, Class<? extends Annotation> annotation) {
        ArrayList classList = new ArrayList();
        if (ObjectUtils.isEmpty((Object)packagePath)) {
            return classList;
        }
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        TypeFilter includeFilter = (metadataReader, metadataReaderFactory) -> true;
        provider.addIncludeFilter(includeFilter);
        HashSet beanDefinitionSet = new HashSet();
        Set candidateComponents = provider.findCandidateComponents(packagePath);
        beanDefinitionSet.addAll(candidateComponents);
        beanDefinitionSet.forEach(beanDefinition -> {
            try {
                Class<?> clazz = Class.forName(beanDefinition.getBeanClassName());
                if (!ObjectUtils.isEmpty((Object)annotation)) {
                    if (!ObjectUtils.isEmpty((Object)AnnotationUtils.getAnnotation(clazz, (Class)annotation))) {
                        classList.add(clazz);
                    }
                } else {
                    classList.add(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
        return classList;
    }
}

