/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.inner.lazy.orm.spring.processor;

import java.io.BufferedWriter;
import java.io.File;
import java.net.URL;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.wu.framework.core.utils.FileUtil;
import org.wu.framework.lazy.orm.core.config.ddl.LazyDdlConfigureAttribute;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;

public class LazyTablePostProcessor
implements Ordered,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LazyTablePostProcessor.class);
    private final LazyDdlConfigureAttribute lazyDdlConfigureAttribute;

    public LazyTablePostProcessor(LazyDdlConfigureAttribute lazyDdlConfigureAttribute) {
        this.lazyDdlConfigureAttribute = lazyDdlConfigureAttribute;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void afterPropertiesSet() throws Exception {
        BufferedWriter bufferedWriter = null;
        try {
            if (this.lazyDdlConfigureAttribute.isOutPutTableStructure()) {
                URL resource = LazyTablePostProcessor.class.getResource("/");
                String resourceFilePrefix = resource.getFile();
                String target = resourceFilePrefix.split("target")[0] + "src/main/resources/";
                resourceFilePrefix = target + "sql" + File.separator;
                bufferedWriter = FileUtil.createFileBufferedWriter(null, (String)resourceFilePrefix, (String)".sql", (String)"schema");
            }
            List tableClass = LazyDatabaseJsonMessage.localCacheEntityClass;
            for (Class clazz : tableClass) {
                try {
                    if (bufferedWriter == null) continue;
                    SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance((Class)clazz);
                    LazyTableEndpoint lazyTableEndpoint = sqlSourceClass.getLazyTableEndpoint();
                    String creatTableSQL = lazyTableEndpoint.creatTableSQL();
                    bufferedWriter.write(creatTableSQL);
                    bufferedWriter.newLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

