/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.inner.lazy.orm.spring.config;

import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Role;
import org.wu.framework.inner.lazy.orm.spring.SpringConnectionHandler;
import org.wu.framework.inner.lazy.orm.spring.SpringDataSourceHandler;
import org.wu.framework.lazy.database.datasource.proxy.LazyProxyDataSource;
import org.wu.framework.lazy.database.datasource.proxy.audit.LazyAuditAdapter;
import org.wu.framework.lazy.database.datasource.proxy.handler.ConnectionHandler;
import org.wu.framework.lazy.database.datasource.proxy.handler.DataSourceHandler;
import org.wu.framework.lazy.database.datasource.proxy.handler.JdbcHandlerAdapter;
import org.wu.framework.lazy.database.datasource.proxy.util.LazyDataSourceProxyUtils;

@ConditionalOnProperty(prefix="spring.datasource", value={"url"})
@Role(value=2)
public class LazyDataSourceProxyAutoConfiguration {
    @Role(value=2)
    @Bean
    public JdbcHandlerAdapter jdbcHandlerAdapter(List<DataSourceHandler> dataSourceHandlerList, List<ConnectionHandler> connectionHandlerList, LazyAuditAdapter lazyAuditAdapter) {
        return new JdbcHandlerAdapter(dataSourceHandlerList, connectionHandlerList, lazyAuditAdapter);
    }

    @Bean
    @Primary
    @Role(value=2)
    @ConditionalOnProperty(prefix="spring.datasource", value={"use-proxy"}, havingValue="true", matchIfMissing=true)
    public LazyProxyDataSource lazyProxyDataSource(DataSource dataSource, JdbcHandlerAdapter jdbcHandlerAdapter) {
        return LazyDataSourceProxyUtils.proxy((DataSource)dataSource, (JdbcHandlerAdapter)jdbcHandlerAdapter);
    }

    @Bean
    @Role(value=2)
    public SpringConnectionHandler springConnectionHandler() {
        return new SpringConnectionHandler();
    }

    @Bean
    @Role(value=2)
    public SpringDataSourceHandler springDataSourceHandler() {
        return new SpringDataSourceHandler();
    }
}

