/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.inner.lazy.orm.spring.aop;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.LazyTableArgsTranslation;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.LazyTableTranslation;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.adapter.LazyTranslationAdapter;

public class LazyTranslationPointcutAdvisor
extends AbstractPointcutAdvisor {
    private static final Logger log = LoggerFactory.getLogger(LazyTranslationPointcutAdvisor.class);
    private final Advice advice;
    private final Pointcut pointcut;

    public LazyTranslationPointcutAdvisor(LazyTranslationAdapter translationAdapter) {
        this.advice = new MonitorCurrentMethodInterceptor(translationAdapter);
        this.pointcut = this.buildPointcut();
    }

    private Pointcut buildPointcut() {
        AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(LazyTableTranslation.class, true);
        AnnotationMatchingPointcut mpc = AnnotationMatchingPointcut.forMethodAnnotation(LazyTableTranslation.class);
        AnnotationMatchingPointcut classAnnotation = AnnotationMatchingPointcut.forClassAnnotation(LazyTableTranslation.class);
        return new ComposablePointcut((Pointcut)cpc).union((Pointcut)mpc).union((Pointcut)classAnnotation);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public static class MonitorCurrentMethodInterceptor
    implements MethodInterceptor {
        private final LazyTranslationAdapter translationAdapter;

        public MonitorCurrentMethodInterceptor(LazyTranslationAdapter translationAdapter) {
            this.translationAdapter = translationAdapter;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object[] arguments = invocation.getArguments();
            Method method = invocation.getMethod();
            Parameter[] methodParameters = method.getParameters();
            for (int i = 0; i < methodParameters.length; ++i) {
                Parameter methodParameter = methodParameters[i];
                LazyTableArgsTranslation annotation = methodParameter.getAnnotation(LazyTableArgsTranslation.class);
                if (annotation == null) continue;
                Object argument = arguments[i];
                this.translationAdapter.transformation(argument);
            }
            Object returnValue = invocation.proceed();
            long start = System.currentTimeMillis();
            this.translationAdapter.transformation(returnValue);
            long end = System.currentTimeMillis();
            log.info("\u8f6c\u6362\u5f53\u524d\u65b9\u6cd5:{} \u6267\u884c\u65f6\u95f4:{}(\u6beb\u79d2) ", (Object)invocation.getMethod().getName(), (Object)(end - start));
            return returnValue;
        }
    }
}

