/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.inner.lazy.orm.spring.adapter;

import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.database.datasource.proxy.LazyProxyDataSource;
import org.wu.framework.lazy.database.datasource.proxy.connection.LazyProxyConnection;
import org.wu.framework.lazy.orm.database.sql.smart.database.SmartLazyOperation;

@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="spring.lazy", name={"enable-reverse-engineering"}, havingValue="true")
public class ReverseEngineeringAdapter
implements InitializingBean {
    private final LazyProxyDataSource lazyProxyDataSource;
    private final SmartLazyOperation smartLazyOperation;

    public ReverseEngineeringAdapter(LazyProxyDataSource lazyProxyDataSource, SmartLazyOperation smartLazyOperation) {
        this.lazyProxyDataSource = lazyProxyDataSource;
        this.smartLazyOperation = smartLazyOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        LazyProxyConnection lazyConnection = this.lazyProxyDataSource.getLazyConnection();
        String catalog = lazyConnection.getCatalog();
        catalog = ObjectUtils.isEmpty((Object)catalog) ? lazyConnection.getSchema() : catalog;
        try {
            if (catalog == null) {
                return;
            }
            ((Stream)this.smartLazyOperation.showTables(catalog).stream().parallel()).forEach(showTable -> this.smartLazyOperation.stuffedJava(showTable.getTableSchema(), showTable.getTableName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            lazyConnection.connectionClose();
        }
    }
}

