/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.converters;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.bigdecimal.BigDecimalBooleanConverter;
import com.alibaba.excel.converters.bigdecimal.BigDecimalNumberConverter;
import com.alibaba.excel.converters.bigdecimal.BigDecimalStringConverter;
import com.alibaba.excel.converters.booleanconverter.BooleanBooleanConverter;
import com.alibaba.excel.converters.booleanconverter.BooleanNumberConverter;
import com.alibaba.excel.converters.booleanconverter.BooleanStringConverter;
import com.alibaba.excel.converters.bytearray.BoxingByteArrayImageConverter;
import com.alibaba.excel.converters.bytearray.ByteArrayImageConverter;
import com.alibaba.excel.converters.byteconverter.ByteBooleanConverter;
import com.alibaba.excel.converters.byteconverter.ByteNumberConverter;
import com.alibaba.excel.converters.byteconverter.ByteStringConverter;
import com.alibaba.excel.converters.date.DateNumberConverter;
import com.alibaba.excel.converters.date.DateStringConverter;
import com.alibaba.excel.converters.doubleconverter.DoubleBooleanConverter;
import com.alibaba.excel.converters.doubleconverter.DoubleNumberConverter;
import com.alibaba.excel.converters.doubleconverter.DoubleStringConverter;
import com.alibaba.excel.converters.file.FileImageConverter;
import com.alibaba.excel.converters.floatconverter.FloatBooleanConverter;
import com.alibaba.excel.converters.floatconverter.FloatNumberConverter;
import com.alibaba.excel.converters.floatconverter.FloatStringConverter;
import com.alibaba.excel.converters.inputstream.InputStreamImageConverter;
import com.alibaba.excel.converters.integer.IntegerBooleanConverter;
import com.alibaba.excel.converters.integer.IntegerNumberConverter;
import com.alibaba.excel.converters.integer.IntegerStringConverter;
import com.alibaba.excel.converters.longconverter.LongBooleanConverter;
import com.alibaba.excel.converters.longconverter.LongNumberConverter;
import com.alibaba.excel.converters.longconverter.LongStringConverter;
import com.alibaba.excel.converters.shortconverter.ShortBooleanConverter;
import com.alibaba.excel.converters.shortconverter.ShortNumberConverter;
import com.alibaba.excel.converters.shortconverter.ShortStringConverter;
import com.alibaba.excel.converters.string.StringBooleanConverter;
import com.alibaba.excel.converters.string.StringErrorConverter;
import com.alibaba.excel.converters.string.StringNumberConverter;
import com.alibaba.excel.converters.string.StringStringConverter;
import com.alibaba.excel.converters.url.UrlImageConverter;
import java.util.HashMap;
import java.util.Map;

public class DefaultConverterLoader {
    private static Map<String, Converter> defaultWriteConverter;
    private static Map<String, Converter> allConverter;

    private static void initAllConverter() {
        allConverter = new HashMap<String, Converter>(64);
        DefaultConverterLoader.putAllConverter(new BigDecimalBooleanConverter());
        DefaultConverterLoader.putAllConverter(new BigDecimalNumberConverter());
        DefaultConverterLoader.putAllConverter(new BigDecimalStringConverter());
        DefaultConverterLoader.putAllConverter(new BooleanBooleanConverter());
        DefaultConverterLoader.putAllConverter(new BooleanNumberConverter());
        DefaultConverterLoader.putAllConverter(new BooleanStringConverter());
        DefaultConverterLoader.putAllConverter(new ByteBooleanConverter());
        DefaultConverterLoader.putAllConverter(new ByteNumberConverter());
        DefaultConverterLoader.putAllConverter(new ByteStringConverter());
        DefaultConverterLoader.putAllConverter(new DateNumberConverter());
        DefaultConverterLoader.putAllConverter(new DateStringConverter());
        DefaultConverterLoader.putAllConverter(new DoubleBooleanConverter());
        DefaultConverterLoader.putAllConverter(new DoubleNumberConverter());
        DefaultConverterLoader.putAllConverter(new DoubleStringConverter());
        DefaultConverterLoader.putAllConverter(new FloatBooleanConverter());
        DefaultConverterLoader.putAllConverter(new FloatNumberConverter());
        DefaultConverterLoader.putAllConverter(new FloatStringConverter());
        DefaultConverterLoader.putAllConverter(new IntegerBooleanConverter());
        DefaultConverterLoader.putAllConverter(new IntegerNumberConverter());
        DefaultConverterLoader.putAllConverter(new IntegerStringConverter());
        DefaultConverterLoader.putAllConverter(new LongBooleanConverter());
        DefaultConverterLoader.putAllConverter(new LongNumberConverter());
        DefaultConverterLoader.putAllConverter(new LongStringConverter());
        DefaultConverterLoader.putAllConverter(new ShortBooleanConverter());
        DefaultConverterLoader.putAllConverter(new ShortNumberConverter());
        DefaultConverterLoader.putAllConverter(new ShortStringConverter());
        DefaultConverterLoader.putAllConverter(new StringBooleanConverter());
        DefaultConverterLoader.putAllConverter(new StringNumberConverter());
        DefaultConverterLoader.putAllConverter(new StringStringConverter());
        DefaultConverterLoader.putAllConverter(new StringErrorConverter());
    }

    private static void initDefaultWriteConverter() {
        defaultWriteConverter = new HashMap<String, Converter>(32);
        DefaultConverterLoader.putWriteConverter(new BigDecimalNumberConverter());
        DefaultConverterLoader.putWriteConverter(new BooleanBooleanConverter());
        DefaultConverterLoader.putWriteConverter(new ByteNumberConverter());
        DefaultConverterLoader.putWriteConverter(new DateStringConverter());
        DefaultConverterLoader.putWriteConverter(new DoubleNumberConverter());
        DefaultConverterLoader.putWriteConverter(new FloatNumberConverter());
        DefaultConverterLoader.putWriteConverter(new IntegerNumberConverter());
        DefaultConverterLoader.putWriteConverter(new LongNumberConverter());
        DefaultConverterLoader.putWriteConverter(new ShortNumberConverter());
        DefaultConverterLoader.putWriteConverter(new StringStringConverter());
        DefaultConverterLoader.putWriteConverter(new FileImageConverter());
        DefaultConverterLoader.putWriteConverter(new InputStreamImageConverter());
        DefaultConverterLoader.putWriteConverter(new ByteArrayImageConverter());
        DefaultConverterLoader.putWriteConverter(new BoxingByteArrayImageConverter());
        DefaultConverterLoader.putWriteConverter(new UrlImageConverter());
    }

    public static Map<String, Converter> loadDefaultWriteConverter() {
        return defaultWriteConverter;
    }

    private static void putWriteConverter(Converter converter) {
        defaultWriteConverter.put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey()), converter);
    }

    public static Map<String, Converter> loadDefaultReadConverter() {
        return DefaultConverterLoader.loadAllConverter();
    }

    public static Map<String, Converter> loadAllConverter() {
        return allConverter;
    }

    private static void putAllConverter(Converter converter) {
        allConverter.put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey(), converter.supportExcelTypeKey()), converter);
    }

    static {
        DefaultConverterLoader.initDefaultWriteConverter();
        DefaultConverterLoader.initAllConverter();
    }
}

