/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.encryption;

import java.security.MessageDigest;
import java.util.function.Supplier;
import org.wu.framework.translation.data.encryption.AbstractEncryptionDecryption;
import org.wu.framework.translation.data.encryption.enums.EncryptionDecryptionEnum;

public class EncryptionDecryptionMd5
extends AbstractEncryptionDecryption {
    @Override
    public boolean support(EncryptionDecryptionEnum encryptionDecryptionEnum) {
        return EncryptionDecryptionEnum.MD5.equals((Object)encryptionDecryptionEnum);
    }

    @Override
    public Object encryption(Object source, Supplier<?> supplier) {
        try {
            MessageDigest md = MessageDigest.getInstance(EncryptionDecryptionEnum.MD5.name());
            byte[] inputBytes = source.toString().getBytes();
            md.update(inputBytes);
            byte[] digestBytes = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digestBytes) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object decryption(Object encryptionSource, Supplier<?> supplier) {
        return null;
    }
}

