/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.dictionary.convert;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.translation.data.dictionary.ConvertField;
import org.wu.framework.translation.data.dictionary.ConvertFieldBean;
import org.wu.framework.translation.data.dictionary.convert.LazyDictionaryConvert;

public abstract class AbstractLazyDictionaryConvert
implements LazyDictionaryConvert {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLazyDictionaryConvert.class);

    public Map<String, Map<String, String>> conversionTemplateMaps(Object ... sources) {
        ConcurrentHashMap<String, Map<String, String>> conversionTemplateMaps = new ConcurrentHashMap();
        List<Class<?>> sourceClassList = this.sourceClassList(sources);
        List<String> convertItemList = this.getSourceConvertItemList(sourceClassList);
        if (ObjectUtils.isEmpty(convertItemList)) {
            return new ConcurrentHashMap<String, Map<String, String>>();
        }
        try {
            conversionTemplateMaps = this.getConversionTemplateMapsByItems(convertItemList, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("fail to init api:{}", (Object)e.getMessage());
        }
        return conversionTemplateMaps;
    }

    protected abstract ConcurrentHashMap<String, Map<String, String>> getConversionTemplateMapsByItems(List<String> var1, boolean var2);

    public List<Class<?>> sourceClassList(Object ... sources) {
        List sourceClassList = Arrays.stream(Arrays.stream(sources).filter(o -> !ObjectUtils.isEmpty((Object)o)).map(o -> {
            if (o instanceof Collection && !ObjectUtils.isEmpty((Object)o)) {
                return ((Collection)o).iterator().next().getClass();
            }
            return o.getClass();
        }).toArray(Class[]::new)).collect(Collectors.toList());
        ArrayList classList = new ArrayList();
        for (Class sourceClass : sourceClassList) {
            classList.add(sourceClass);
            this.deepSourceClassList(classList, sourceClass);
        }
        return classList;
    }

    public List<Class<?>> deepSourceClassList(List<Class<?>> sourceClassList, Class<?> deepSourceClassList) {
        if (null == sourceClassList) {
            sourceClassList = new ArrayList();
        }
        for (Field declaredField : deepSourceClassList.getDeclaredFields()) {
            Type genericType;
            if (!this.isFieldSupportDeep(declaredField) || !((genericType = declaredField.getGenericType()) instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Type rawType = parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom((Class)rawType)) {
                Class actualTypeArgument = (Class)actualTypeArguments[0];
                if (sourceClassList.contains(actualTypeArgument)) {
                    return sourceClassList;
                }
                sourceClassList.add(actualTypeArgument);
                return this.deepSourceClassList(sourceClassList, actualTypeArgument);
            }
            if (!(rawType instanceof Map)) continue;
            Type mapKeyType = actualTypeArguments[0];
            Type type = actualTypeArguments[1];
        }
        return sourceClassList;
    }

    public boolean isFieldSupportDeep(Field field) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, ConvertFieldBean.class);
    }

    private List<String> getSourceConvertItemList(List<Class<?>> classList) {
        ArrayList<String> convertItemList = new ArrayList<String>();
        if (ObjectUtils.isEmpty(classList)) {
            return convertItemList;
        }
        for (Class<?> aClass : classList) {
            Field[] fields;
            for (Field field : fields = aClass.getDeclaredFields()) {
                String convertItem;
                if (!this.isFieldConvert(field) || ObjectUtils.isEmpty((Object)(convertItem = this.getConvertItem(field))) || convertItemList.contains(convertItem)) continue;
                convertItemList.add(convertItem);
            }
        }
        return convertItemList;
    }

    public boolean isFieldConvert(Field field) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, ConvertField.class);
    }

    public String getConvertItem(Field field) {
        ConvertField mergedAnnotation = (ConvertField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, ConvertField.class);
        return mergedAnnotation.convertItem();
    }

    public void convertObjects(Map<String, Map<String, String>> dictionaryDataMap, Object ... objects) {
        if (ObjectUtils.isEmpty((Object)objects)) {
            return;
        }
        for (Object object : objects) {
            if (ObjectUtils.isEmpty((Object)object)) continue;
            if (object instanceof Collection) {
                this.convertCollection(dictionaryDataMap, (Collection)object);
                continue;
            }
            this.convert(object, dictionaryDataMap);
        }
    }

    protected void convertCollection(Map<String, Map<String, String>> dictionaryDataMap, Collection<?> collection) {
        for (Object o : collection) {
            if (o instanceof Collection) {
                this.convertCollection(dictionaryDataMap, (Collection)o);
                continue;
            }
            this.convert(o, dictionaryDataMap);
        }
    }

    protected abstract void convert(Object var1, Map<String, Map<String, String>> var2);

    @Override
    public void transformation(Object source) {
        Map<String, Map<String, String>> stringObjectConcurrentHashMap = this.conversionTemplateMaps(source);
        this.convertObjects(stringObjectConcurrentHashMap, source);
    }
}

