/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.convert;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.wu.framework.translation.data.convert.AbstractLayerOperationConvert;

public class LayerOperationConvertLocalDateTime
extends AbstractLayerOperationConvert {
    @Override
    public boolean support(Class<?> fieldType) {
        return fieldType.equals(LocalDateTime.class);
    }

    public Object handler(Object fieldValue, Class fieldType) {
        Class<?> fieldValueClass = fieldValue.getClass();
        if (LocalDateTime.class.isAssignableFrom(fieldValueClass)) {
            return fieldValue;
        }
        if (Timestamp.class.isAssignableFrom(fieldValueClass)) {
            Timestamp timestamp = (Timestamp)fieldValue;
            return timestamp.toLocalDateTime();
        }
        if (Date.class.isAssignableFrom(fieldValueClass)) {
            Date date = (Date)fieldValue;
            ZoneId zoneId = ZoneId.systemDefault();
            return LocalDateTime.ofInstant(date.toInstant(), zoneId);
        }
        if (java.sql.Date.class.isAssignableFrom(fieldValueClass)) {
            java.sql.Date date = (java.sql.Date)fieldValue;
            ZoneId zoneId = ZoneId.systemDefault();
            return LocalDateTime.ofInstant(date.toInstant(), zoneId);
        }
        return null;
    }

    public Object handler(Object fieldValue, Field field) {
        return this.handler(fieldValue, (Class)field.getType());
    }
}

