/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.convert;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Date;
import org.wu.framework.translation.data.convert.AbstractLayerOperationConvert;

public class LayerOperationConvertDate
extends AbstractLayerOperationConvert {
    @Override
    public boolean support(Class<?> fieldType) {
        return fieldType.equals(Date.class) || fieldType.equals(java.sql.Date.class);
    }

    public Object handler(Object fieldValue, Class fieldType) {
        Class<?> fieldValueClass = fieldValue.getClass();
        if (Date.class.isAssignableFrom(fieldValueClass)) {
            return fieldValue;
        }
        if (java.sql.Date.class.isAssignableFrom(fieldValueClass)) {
            java.sql.Date timestamp = (java.sql.Date)fieldValue;
            return new Date(timestamp.getTime());
        }
        if (LocalDateTime.class.isAssignableFrom(fieldValueClass)) {
            LocalDateTime timestamp = (LocalDateTime)fieldValue;
            return new Date(timestamp.getNano());
        }
        return null;
    }

    public Object handler(Object fieldValue, Field field) {
        return this.handler(fieldValue, (Class)field.getType());
    }
}

