/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.limit;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.wu.framework.translation.data.limit.EasyAccessLimit;
import org.wu.framework.translation.data.limit.IAccessLimit;

public class DefaultIAccessLimit
implements IAccessLimit {
    private ExpiryMap<String, Integer> accessLimitMap = new ExpiryMap();

    @Override
    public void andThen(EasyAccessLimit accessLimit, String key) {
        int seconds = accessLimit.seconds();
        int maxCount = accessLimit.maxCount();
        String msg = accessLimit.msg();
        if (!this.accessLimitMap.containsKey(key) || this.accessLimitMap.isInvalid(key).booleanValue()) {
            this.accessLimitMap.put(key, 0, 1000L * (long)seconds);
        } else {
            this.accessLimitMap.put(key, this.accessLimitMap.get(key) + 1, this.accessLimitMap.getExpiryTime(key) - System.currentTimeMillis());
        }
        if (this.accessLimitMap.get(key) + 1 > maxCount) {
            throw new RuntimeException(msg);
        }
    }

    public class ExpiryMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private long EXPIRY;
        private HashMap<K, Long> expiryMap;

        public ExpiryMap() {
            this.EXPIRY = 120000L;
            this.expiryMap = new HashMap();
        }

        public ExpiryMap(long defaultExpiryTime) {
            this(16, defaultExpiryTime);
        }

        public ExpiryMap(int initialCapacity, long defaultExpiryTime) {
            super(initialCapacity);
            this.EXPIRY = 120000L;
            this.expiryMap = new HashMap();
            this.EXPIRY = defaultExpiryTime;
        }

        @Override
        public V put(K key, V value) {
            this.expiryMap.put(key, System.currentTimeMillis() + this.EXPIRY);
            return super.put(key, value);
        }

        @Override
        public boolean containsKey(Object key) {
            return !this.checkExpiry(key, true) && super.containsKey(key);
        }

        public V put(K key, V value, long expiryTime) {
            this.expiryMap.put(key, System.currentTimeMillis() + expiryTime);
            return super.put(key, value);
        }

        @Override
        public int size() {
            return this.entrySet().size();
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().size() == 0;
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                return Boolean.FALSE;
            }
            Set set = super.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!value.equals(entry.getValue())) continue;
                if (this.checkExpiry(entry.getKey(), false)) {
                    iterator.remove();
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Collection<V> values() {
            Collection values = super.values();
            if (values == null || values.size() < 1) {
                return values;
            }
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (this.containsValue(next)) continue;
                iterator.remove();
            }
            return values;
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                return null;
            }
            if (this.checkExpiry(key, true)) {
                return null;
            }
            return super.get(key);
        }

        public Boolean isInvalid(Object key) {
            boolean flag;
            if (key == null) {
                return true;
            }
            if (!this.expiryMap.containsKey(key)) {
                return true;
            }
            long expiryTime = this.expiryMap.get(key);
            boolean bl = flag = System.currentTimeMillis() > expiryTime;
            if (flag) {
                super.remove(key);
                this.expiryMap.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.expiryMap.put(e.getKey(), System.currentTimeMillis() + this.EXPIRY);
            }
            super.putAll(m);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set set = super.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!this.checkExpiry(entry.getKey(), false)) continue;
                iterator.remove();
            }
            return set;
        }

        private boolean checkExpiry(Object key, boolean isRemoveSuper) {
            boolean flag;
            if (!this.expiryMap.containsKey(key)) {
                return Boolean.FALSE;
            }
            long expiryTime = this.expiryMap.get(key);
            boolean bl = flag = System.currentTimeMillis() > expiryTime;
            if (flag) {
                if (isRemoveSuper) {
                    super.remove(key);
                }
                this.expiryMap.remove(key);
            }
            return flag;
        }

        public long getExpiryTime(String key) {
            return this.expiryMap.get(key);
        }
    }
}

