/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.encryption;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import org.wu.framework.translation.data.encryption.AbstractEncryptionDecryption;
import org.wu.framework.translation.data.encryption.enums.EncryptionDecryptionEnum;

public class EncryptionDecryptionAsymmetricCryptography
extends AbstractEncryptionDecryption {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int KEY_PAIR_INIT_SIZE = 2048;
    private static final int MAX_DECRYPT_BLOCK = 256;
    private static Map<String, Object> keyMap = new HashMap<String, Object>(2);
    private static final char[] HEX_CHAR;

    public static String getPublicKeyStr(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return EncryptionDecryptionAsymmetricCryptography.encryptBASE64(key.getEncoded());
    }

    public static String getPrivateKeyStr(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return EncryptionDecryptionAsymmetricCryptography.encryptBASE64(key.getEncoded());
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = EncryptionDecryptionAsymmetricCryptography.decryptBASE64(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = EncryptionDecryptionAsymmetricCryptography.decryptBASE64(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static byte[] decryptBASE64(String key) {
        return Base64.getMimeDecoder().decode(key);
    }

    public static String encryptBASE64(byte[] key) {
        return Base64.getMimeEncoder().encodeToString(key);
    }

    public static String sign(byte[] data, String privateKeyStr) throws Exception {
        PrivateKey priK = EncryptionDecryptionAsymmetricCryptography.getPrivateKey(new String(EncryptionDecryptionAsymmetricCryptography.hexToBytes(privateKeyStr)));
        Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
        sig.initSign(priK);
        sig.update(data);
        return EncryptionDecryptionAsymmetricCryptography.bytesToHex(sig.sign());
    }

    public static boolean verify(byte[] data, String sign, String publicKeyStr) throws Exception {
        PublicKey pubK = EncryptionDecryptionAsymmetricCryptography.getPublicKey(new String(EncryptionDecryptionAsymmetricCryptography.hexToBytes(publicKeyStr)));
        Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
        sig.initVerify(pubK);
        sig.update(data);
        return sig.verify(EncryptionDecryptionAsymmetricCryptography.hexToBytes(sign));
    }

    public static String encrypt(byte[] plainText, String publicKeyStr) throws Exception {
        PublicKey publicKey = EncryptionDecryptionAsymmetricCryptography.getPublicKey(publicKeyStr);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, publicKey);
        int inputLen = plainText.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(plainText, offSet, 117) : cipher.doFinal(plainText, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptText = out.toByteArray();
        out.close();
        return EncryptionDecryptionAsymmetricCryptography.bytesToHex(encryptText);
    }

    public static String decrypt(String encryptTextHex, String privateKeyStr) throws Exception {
        byte[] encryptText = EncryptionDecryptionAsymmetricCryptography.hexToBytes(encryptTextHex);
        PrivateKey privateKey = EncryptionDecryptionAsymmetricCryptography.getPrivateKey(privateKeyStr);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, privateKey);
        int inputLen = encryptText.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(encryptText, offSet, 256) : cipher.doFinal(encryptText, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 256;
        }
        byte[] plainText = out.toByteArray();
        out.close();
        return new String(plainText);
    }

    public static Map<String, Object> initKey() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(2048);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] buf = new char[bytes.length * 2];
        int a = 0;
        int index = 0;
        for (int n : bytes) {
            a = n < 0 ? 256 + n : n;
            buf[index++] = HEX_CHAR[a / 16];
            buf[index++] = HEX_CHAR[a % 16];
        }
        return new String(buf);
    }

    public static byte[] hexToBytes(String str) {
        if (str == null || "".equals(str.trim())) {
            return new byte[0];
        }
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < str.length() / 2; ++i) {
            String subStr = str.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return bytes;
    }

    public static void main(String[] args) throws Exception {
        Map<String, Object> keyMap = EncryptionDecryptionAsymmetricCryptography.initKey();
        String publicKey = EncryptionDecryptionAsymmetricCryptography.getPublicKeyStr(keyMap);
        String privateKey = EncryptionDecryptionAsymmetricCryptography.getPrivateKeyStr(keyMap);
        System.out.println("\u516c\u94a5\uff1a\uff08\u586b\u5145\u65b9\u5f0f\uff1aPKCS1_PADDING\uff0c\u8f93\u51fa\u7c7b\u578b\uff1abase64\uff0c\u5b57\u7b26\u96c6\uff1autf8\u7f16\u7801\uff09");
        System.out.println("-----BEGIN PUBLIC KEY-----");
        System.out.println(publicKey);
        System.out.println("-----END PUBLIC KEY-----");
        System.out.println("\n");
        System.out.println("\u79c1\u94a5\uff1a\uff08\u586b\u5145\u65b9\u5f0f\uff1aPKCS1_PADDING\uff0c\u8f93\u51fa\u7c7b\u578b\uff1abase64\uff0c\u5b57\u7b26\u96c6\uff1autf8\u7f16\u7801\uff09");
        System.out.println("-----BEGIN RSA PRIVATE KEY-----");
        System.out.println(privateKey);
        System.out.println("-----END RSA PRIVATE KEY-----");
        System.out.println("\n");
        String s = "123";
        String encrypt = EncryptionDecryptionAsymmetricCryptography.encrypt(s.getBytes(), publicKey);
        System.out.println("\u5bc6\u6587\uff1a\uff08\u586b\u5145\u65b9\u5f0f\uff1aPKCS1_PADDING\uff0c\u8f93\u51fa\u7c7b\u578b\uff1ahex\uff0c\u5b57\u7b26\u96c6\uff1autf8\u7f16\u7801\uff09");
        System.out.println(encrypt);
        System.out.println("\n");
        String decrypt = EncryptionDecryptionAsymmetricCryptography.decrypt(encrypt, privateKey);
        System.out.println("\u89e3\u5bc6\u540e\u660e\u6587: ");
        System.out.println(decrypt);
    }

    @Override
    public boolean support(EncryptionDecryptionEnum encryptionDecryptionEnum) {
        return EncryptionDecryptionEnum.RSA.equals((Object)encryptionDecryptionEnum);
    }

    @Override
    public Object encryption(Object source, Supplier<?> supplier) {
        try {
            Map keyMap = EncryptionDecryptionAsymmetricCryptography.keyMap;
            if (supplier != null) {
                keyMap = (Map)supplier.get();
            }
            String publicKey = EncryptionDecryptionAsymmetricCryptography.getPublicKeyStr(keyMap);
            String encrypt = EncryptionDecryptionAsymmetricCryptography.encrypt(source.toString().getBytes(), publicKey);
            return encrypt;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object decryption(Object encryptionSource, Supplier<?> supplier) {
        try {
            Map keyMap = EncryptionDecryptionAsymmetricCryptography.keyMap;
            if (supplier != null) {
                keyMap = (Map)supplier.get();
            }
            String privateKey = EncryptionDecryptionAsymmetricCryptography.getPrivateKeyStr(keyMap);
            String decrypt = EncryptionDecryptionAsymmetricCryptography.decrypt(encryptionSource.toString(), privateKey);
            return decrypt;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        keyPairGen.initialize(2048);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

