/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data.dictionary.convert;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.translation.data.convert.LazyDataFactory;
import org.wu.framework.translation.data.dictionary.ConvertField;
import org.wu.framework.translation.data.dictionary.ConvertFieldBean;
import org.wu.framework.translation.data.dictionary.api.ConvertApi;
import org.wu.framework.translation.data.dictionary.convert.AbstractLazyDictionaryConvert;

public class DefaultLazyDictionaryConvert
extends AbstractLazyDictionaryConvert {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultLazyDictionaryConvert.class);
    private final ConvertApi convertApi;

    public DefaultLazyDictionaryConvert(ConvertApi convertApi) {
        this.convertApi = convertApi;
    }

    @Override
    protected ConcurrentHashMap<String, Map<String, String>> getConversionTemplateMapsByItems(List<String> convertItemList, boolean order) {
        Map<String, Map<String, String>> convertDataByItems = this.convertApi.getConvertDataByItems(convertItemList, order);
        return new ConcurrentHashMap<String, Map<String, String>>(convertDataByItems);
    }

    @Override
    protected void convert(Object object, Map<String, Map<String, String>> dictionaryDataMap) {
        Class<?> clazz = object.getClass();
        Field[] clazzDeclaredFields = clazz.getDeclaredFields();
        Map<String, Field> fieldMap = Arrays.stream(clazzDeclaredFields).collect(Collectors.toMap(Field::getName, field -> {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field;
        }));
        for (Field field2 : clazzDeclaredFields) {
            try {
                String entryName;
                String[] keys;
                if (!field2.isAccessible()) {
                    field2.setAccessible(true);
                }
                String fieldName = field2.getName();
                Object fieldVal = field2.get(object);
                Class<?> fieldType = field2.getType();
                ConvertFieldBean convertFieldBean = field2.getAnnotation(ConvertFieldBean.class);
                if (!ObjectUtils.isEmpty((Object)convertFieldBean)) {
                    this.convertObjects(dictionaryDataMap, fieldVal);
                    continue;
                }
                ConvertField convertField = (ConvertField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field2, ConvertField.class);
                if (ObjectUtils.isEmpty((Object)convertField) || ObjectUtils.isEmpty((Object)fieldVal)) continue;
                ConvertField.ConvertDictionaryWay convertDictionaryWay = convertField.convertDictionaryWay();
                String convertItem = this.getConvertItem(field2);
                Map<String, String> dictionaryItemDataMap = dictionaryDataMap.get(convertItem);
                String entryVal = "";
                if (ConvertField.ConvertDictionaryWay.DICTIONARY_TO_CHINESE.equals((Object)convertDictionaryWay)) {
                    if (!ObjectUtils.isEmpty(dictionaryItemDataMap)) {
                        keys = !ObjectUtils.isEmpty((Object)convertField.convertSplitCharacter()) ? String.valueOf(fieldVal).split(String.join((CharSequence)"|", convertField.convertSplitCharacter())) : new String[]{String.valueOf(fieldVal)};
                        entryVal = Arrays.stream(keys).map(s -> dictionaryItemDataMap.getOrDefault(s, convertField.defaultValue())).collect(Collectors.joining(","));
                    }
                    entryName = ObjectUtils.isEmpty((Object)convertField.chineseNameProperty()) ? fieldName + "Name" : convertField.chineseNameProperty();
                } else {
                    if (!ObjectUtils.isEmpty(dictionaryItemDataMap)) {
                        Map<String, String> reversalDictionaryItemDataMap = dictionaryItemDataMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
                        keys = !ObjectUtils.isEmpty((Object)convertField.convertSplitCharacter()) ? String.valueOf(fieldVal).split(String.join((CharSequence)"|", convertField.convertSplitCharacter())) : new String[]{String.valueOf(fieldVal)};
                        entryVal = Arrays.stream(keys).map(s -> reversalDictionaryItemDataMap.getOrDefault(s, convertField.defaultValue())).collect(Collectors.joining(","));
                    }
                    entryName = ObjectUtils.isEmpty((Object)convertField.chineseNameProperty()) ? fieldName.replace("Name", "") : convertField.chineseNameProperty();
                }
                if (!fieldMap.containsKey(entryName)) continue;
                Field entryField = fieldMap.get(entryName);
                LazyDataFactory.handler(object, entryField, entryVal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean support(Object source) {
        return source != null;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

