/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.translation.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum JavaBasicTypeDefaultValue {
    STRING(String.class, ""),
    BOOLEAN(Boolean.class, false),
    BOOLEAN_M(Boolean.TYPE, false),
    Byte(Byte.class, 0),
    Byte_M(java.lang.Byte.TYPE, 0),
    Byte_S(Byte[].class, 0),
    Byte_M_S(byte[].class, 0),
    INTEGER(Integer.class, 0),
    INT(Integer.TYPE, 0),
    BigInteger(BigInteger.class, 0),
    LONG(Long.class, 0L),
    LONG_M(Long.TYPE, 0L),
    SHORT(Short.class, 0),
    SHORT_M(Short.TYPE, 0),
    CHARACTER(Character.class, 0),
    CHAR(Character.TYPE, 0),
    FLOAT(Float.class, Float.valueOf(0.0f)),
    FLOAT_M(Float.TYPE, Float.valueOf(0.0f)),
    DOUBLE(Double.class, 0.0),
    DOUBLE_M(Double.TYPE, 0.0),
    BIG_DECIMAL(BigDecimal.class, 0),
    LOCAL_DATE(LocalDate.class, LocalDate.now()),
    LOCAL_DATE_TIME(LocalDateTime.class, LocalDateTime.now()),
    TIMESTAMP(Timestamp.class, Timestamp.valueOf(LocalDateTime.now())),
    TIME(Time.class, Time.valueOf(LocalTime.now())),
    DATE(java.util.Date.class, new java.util.Date()),
    SQL_DATE(Date.class, Date.valueOf(LocalDate.now())),
    OBJECT(Object.class, null);

    public static Map<Class, Object> DEFAULT_VALUE_HASHMAP;
    public static Map<String, Object> DEFAULT_CLASS_NAME_VALUE_HASHMAP;
    private Class clazz;
    private Object defaultValue;

    public static Object convertBasicTypeBean(Class clazz, Object obj) {
        if (null == obj) {
            return DEFAULT_VALUE_HASHMAP.get(clazz);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return Integer.valueOf(obj.toString());
        }
        if (clazz.equals(String.class)) {
            return obj.toString();
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return Long.valueOf(obj.toString());
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return Short.valueOf(obj.toString());
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return Double.valueOf(obj.toString());
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return Float.valueOf(obj.toString());
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return Boolean.valueOf(obj.toString());
        }
        if (clazz.equals(Byte.class) || clazz.equals(java.lang.Byte.TYPE)) {
            return obj;
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return obj;
        }
        return obj;
    }

    public static <T> T getDefaultValue(Class<T> clazz) {
        return DEFAULT_VALUE_HASHMAP.getOrDefault(clazz, null);
    }

    public static Object getDefaultValue(String className) {
        try {
            Class<?> forName = Class.forName(className);
            return DEFAULT_VALUE_HASHMAP.getOrDefault(forName, null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Generated
    public Class getClazz() {
        return this.clazz;
    }

    @Generated
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    private JavaBasicTypeDefaultValue(Class clazz, Object defaultValue) {
        this.clazz = clazz;
        this.defaultValue = defaultValue;
    }

    static {
        DEFAULT_VALUE_HASHMAP = new HashMap<Class, Object>();
        DEFAULT_CLASS_NAME_VALUE_HASHMAP = new HashMap<String, Object>();
        Arrays.stream(JavaBasicTypeDefaultValue.values()).forEach(javaBasicType -> DEFAULT_VALUE_HASHMAP.put(javaBasicType.clazz, javaBasicType.defaultValue));
        Arrays.stream(JavaBasicTypeDefaultValue.values()).forEach(javaBasicType -> DEFAULT_CLASS_NAME_VALUE_HASHMAP.put(javaBasicType.clazz.getName(), javaBasicType.defaultValue));
    }
}

