/*
 * Decompiled with CFR 0.152.
 */
package org.framework.wu.framework.queue;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.framework.wu.framework.queue.InMemoryMessageQueue;
import org.framework.wu.framework.queue.MessageQueue;

public class MessageQueueFactory {
    private static final Map<String, MessageQueue> QUEUES = new ConcurrentHashMap<String, MessageQueue>();
    private static final int DEFAULT_CAPACITY = 1000;

    public static MessageQueue getQueue(String name) {
        return QUEUES.computeIfAbsent(name, k -> new InMemoryMessageQueue((String)k, 1000));
    }

    public static MessageQueue getQueue(String name, int capacity) {
        return QUEUES.computeIfAbsent(name, k -> new InMemoryMessageQueue((String)k, capacity));
    }

    public static void shutdown() {
        QUEUES.values().forEach(MessageQueue::close);
        QUEUES.clear();
    }
}

