/*
 * Decompiled with CFR 0.152.
 */
package org.framework.wu.framework.queue;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.framework.wu.framework.queue.Message;
import org.framework.wu.framework.queue.MessageQueue;

public class InMemoryMessageQueue
implements MessageQueue {
    private final BlockingQueue<Message> queue;
    private final String name;
    private boolean closed = false;

    public InMemoryMessageQueue(String name, int capacity) {
        this.name = name;
        this.queue = new LinkedBlockingQueue<Message>(capacity);
    }

    @Override
    public boolean send(Message message) {
        if (this.closed) {
            throw new IllegalStateException("Queue is closed");
        }
        try {
            return this.queue.offer(message, 1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public Message receive() {
        if (this.closed) {
            throw new IllegalStateException("Queue is closed");
        }
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public Message receiveNoWait() {
        if (this.closed) {
            throw new IllegalStateException("Queue is closed");
        }
        return (Message)this.queue.poll();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void close() {
        this.closed = true;
        this.queue.clear();
    }

    public String getName() {
        return this.name;
    }
}

