/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.inner.lazy.orm.spring.aop;

import lombok.NonNull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.annotation.Role;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDynamicEndpoint;
import org.wu.framework.lazy.orm.core.stereotype.LazyMaster;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyDSContextHolder;

@Role(value=2)
public class LazyMasterDynamicPointcutAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private final Advice advice;
    private final Pointcut pointcut;

    public LazyMasterDynamicPointcutAdvisor(@NonNull LazyClearOtherDBInterceptor lazyDBInterceptor) {
        if (lazyDBInterceptor == null) {
            throw new NullPointerException("lazyDBInterceptor is marked non-null but is null");
        }
        this.advice = lazyDBInterceptor;
        this.pointcut = this.buildPointcut();
    }

    private Pointcut buildPointcut() {
        AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(LazyMaster.class, true);
        AnnotationMatchingPointcut mpc = AnnotationMatchingPointcut.forMethodAnnotation(LazyMaster.class);
        AnnotationMatchingPointcut classAnnotation = AnnotationMatchingPointcut.forClassAnnotation(LazyMaster.class);
        return new ComposablePointcut((Pointcut)cpc).union((Pointcut)mpc).union((Pointcut)classAnnotation);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    }

    public static class LazyClearOtherDBInterceptor
    implements MethodInterceptor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            LazyDynamicEndpoint dynamicEndpoint = DynamicLazyDSContextHolder.peek();
            try {
                DynamicLazyDSContextHolder.clear();
                Object object = invocation.proceed();
                return object;
            }
            finally {
                DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)dynamicEndpoint);
            }
        }
    }
}

