/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.inner.lazy.orm.spring.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.wu.framework.core.Ordered;
import org.wu.framework.core.io.ClassPathScriptResource;
import org.wu.framework.core.io.FileSystemScriptResource;
import org.wu.framework.core.io.ScriptResource;
import org.wu.framework.core.io.UrlScriptResource;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.inner.lazy.orm.spring.util.ScanClassUtil;
import org.wu.framework.lazy.orm.core.config.LazyOperationAttribute;
import org.wu.framework.lazy.orm.core.config.ddl.LazyDdlConfigureAttribute;
import org.wu.framework.lazy.orm.core.config.enums.DDLAuto;
import org.wu.framework.lazy.orm.core.config.prop.LazyDataSourceAttribute;
import org.wu.framework.lazy.orm.core.config.prop.SchemaScript;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.core.stereotype.LazyScan;
import org.wu.framework.lazy.orm.database.lambda.LazyOperation;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.factory.LazyDataSourcePropertiesFactory;

public class LazyScanEntityBeanPostProcessor
implements BeanPostProcessor,
Ordered,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LazyScanEntityBeanPostProcessor.class);
    private final LazyOperation operation;
    private final LazyOperationAttribute operationConfig;
    private final LazyDataSourceAttribute lazyDataSourceAttribute;
    private final LazyDdlConfigureAttribute lazyDdlConfigureAttribute;
    private boolean alreadyAutoSchema = false;

    public LazyScanEntityBeanPostProcessor(LazyOperation operation, LazyOperationAttribute operationConfig, LazyDataSourceAttribute lazyDataSourceAttribute, LazyDdlConfigureAttribute lazyDdlConfigureAttribute) {
        this.operation = operation;
        this.operationConfig = operationConfig;
        this.lazyDataSourceAttribute = lazyDataSourceAttribute;
        this.lazyDdlConfigureAttribute = lazyDdlConfigureAttribute;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        boolean enableAutoSchema;
        String ddlPerfectCommitment = this.lazyDdlConfigureAttribute.getDdlPerfectCommitment();
        DDLAuto ddlAuto = this.lazyDdlConfigureAttribute.getDdlAuto();
        SourceFactory.defaultLazyDataSourceType = this.lazyDataSourceAttribute.getLazyDataSourceType();
        ArrayList tableClass = new ArrayList();
        if (bean.getClass().getAnnotation(LazyScan.class) != null) {
            List<Class<?>> classes;
            LazyScan lazyScan = bean.getClass().getAnnotation(LazyScan.class);
            Class[] scanClass = lazyScan.scanClass();
            tableClass.addAll(Arrays.asList(scanClass));
            String[] stringArray = lazyScan.scanBasePackages();
            Class[] scanBasePackageClasses = lazyScan.scanBasePackageClasses();
            if (!ObjectUtils.isEmpty((Object)stringArray)) {
                for (String scanBasePackage : stringArray) {
                    classes = ScanClassUtil.scanClass(scanBasePackage, null);
                    tableClass.addAll(classes);
                }
            }
            if (!ObjectUtils.isEmpty((Object)scanBasePackageClasses)) {
                for (Class scanBasePackageClass : scanBasePackageClasses) {
                    classes = ScanClassUtil.scanClass(scanBasePackageClass.getPackage().getName(), null);
                    tableClass.addAll(classes);
                }
            }
        }
        if ((enableAutoSchema = this.operationConfig.isEnableAutoSchema()) && !this.alreadyAutoSchema) {
            try {
                LazyDataSourcePropertiesFactory.initSchema((LazyDataSourceAttribute)this.lazyDataSourceAttribute);
                this.alreadyAutoSchema = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u81ea\u52a8\u6cbb\u6108\u6570\u636e\u5e93\u5931\u8d25");
            }
        }
        for (Class clazz : tableClass) {
            try {
                if (DDLAuto.CREATE.equals((Object)ddlAuto)) {
                    this.operation.createTable(new Class[]{clazz});
                    continue;
                }
                if (DDLAuto.UPDATE.equals((Object)ddlAuto)) {
                    this.operation.updateTable(new Class[]{clazz});
                    continue;
                }
                if (DDLAuto.PERFECT.equals((Object)ddlAuto)) {
                    if (ObjectUtils.isEmpty((Object)ddlPerfectCommitment)) {
                        log.warn("\u60a8\u6ca1\u6709\u586b\u5199DDL \u5b8c\u5584\u8868\u627f\u8bfa\u5185\u5bb9\uff0c\u5f53\u524d\u6a21\u5f0f\u5c06\u4e0d\u66f4\u6539\u4efb\u4f55\u6570\u636e\u5e93\uff0c\u8bf7\u914d\u7f6e\u5982 spring.lazy.ddl-configure.ddl-perfect-commitment: \u6211\u627f\u8bfa\u5b8c\u5584\u8868\u7ed3\u6784\uff0c\u652f\u6301\u8868\u5b57\u6bb5\u5220\u9664\u64cd\u4f5c");
                        continue;
                    }
                    this.operation.perfect(new Class[]{clazz});
                    continue;
                }
                if (!DDLAuto.NONE.equals((Object)ddlAuto)) continue;
                SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance((Class)clazz);
                sqlSourceClass.getLazyTableEndpoint();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u65e0\u6cd5\u901a\u8fc7class: " + clazz.getName() + " \u6620\u5c04\u8868");
            }
        }
        return super.postProcessBeforeInitialization(bean, beanName);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return super.postProcessAfterInitialization(bean, beanName);
    }

    public int getOrder() {
        return 0;
    }

    public void afterPropertiesSet() throws Exception {
        ClassPathScriptResource classPathResource;
        ArrayList<ClassPathScriptResource> resources = new ArrayList<ClassPathScriptResource>();
        SchemaScript schemaScript = this.lazyDdlConfigureAttribute.getSchemaScript();
        for (String classPath : schemaScript.getClassPathResources()) {
            classPathResource = new ClassPathScriptResource(classPath);
            resources.add(classPathResource);
        }
        for (String fileSystem : schemaScript.getFileSystemResources()) {
            classPathResource = new FileSystemScriptResource(fileSystem);
            resources.add(classPathResource);
        }
        for (String url : schemaScript.getUrlResources()) {
            classPathResource = new UrlScriptResource(url);
            resources.add(classPathResource);
        }
        if (!resources.isEmpty()) {
            try {
                this.operation.scriptRunner(resources.toArray(new ScriptResource[0]));
            }
            catch (Exception e) {
                log.error("\u6267\u884csql \u6587\u4ef6\u5931\u8d25{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

