/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.inner.lazy.orm.spring.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.wu.framework.inner.lazy.orm.spring.processor.LazyScanEntityBeanPostProcessor;
import org.wu.framework.inner.lazy.orm.spring.prop.ExportDataProperties;
import org.wu.framework.lazy.database.datasource.proxy.handler.JdbcHandlerAdapter;
import org.wu.framework.lazy.database.datasource.proxy.util.LazyDataSourceProxyUtils;
import org.wu.framework.lazy.orm.core.config.LazyOperationAttribute;
import org.wu.framework.lazy.orm.core.config.ddl.LazyDdlConfigureAttribute;
import org.wu.framework.lazy.orm.core.config.prop.LazyDataSourceAttribute;
import org.wu.framework.lazy.orm.database.lambda.LazyBaseDDLOperation;
import org.wu.framework.lazy.orm.database.lambda.LazyBaseDQLOperation;
import org.wu.framework.lazy.orm.database.lambda.LazyBaseOperation;
import org.wu.framework.lazy.orm.database.lambda.LazyOperation;
import org.wu.framework.lazy.orm.database.lambda.dynamic.LazyDynamicDatasourceAdapter;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.LazySqlOperation;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.config.ExportDataAttribute;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.CureAdapter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationMethod;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.ddl.LazyDDLOperationMethod;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.dql.LazyDQLOperationMethod;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.proxy.LazyDDLOperationProxy;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.proxy.LazyDQLOperationProxy;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.proxy.LazyOperationProxy;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.adapter.LazyTranslationAdapter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.api.LazyTableTranslationOneAPI;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.api.LazyTableTranslationOneToManyAPI;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.api.LazyTranslationAPI;
import org.wu.framework.lazy.orm.database.sql.smart.database.SmartLazyOperationAutoStuffed;
import org.wu.framework.lazy.orm.database.sql.smart.database.persistence.LazyOperationSmartAutoStuffed;
import org.wu.framework.lazy.orm.database.sql.smart.database.persistence.PerfectLazyOperation;

@ConditionalOnProperty(prefix="spring.datasource", value={"url"})
@Role(value=2)
public class LazyOperationProxyBeanAutoConfiguration {
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnMissingBean(value={LazyDynamicDatasourceAdapter.class})
    @Bean
    @Role(value=2)
    public LazyDynamicDatasourceAdapter lazyDynamicAdapter(Map<String, DataSource> dataSourceMap, JdbcHandlerAdapter jdbcHandlerAdapter) {
        ConcurrentHashMap lazyProxyDataSourceMap = new ConcurrentHashMap();
        dataSourceMap.forEach((key, dataSource) -> lazyProxyDataSourceMap.put(key, LazyDataSourceProxyUtils.proxy((DataSource)dataSource, (JdbcHandlerAdapter)jdbcHandlerAdapter)));
        LazyDynamicDatasourceAdapter lazyDynamicAdapter = new LazyDynamicDatasourceAdapter(lazyProxyDataSourceMap, jdbcHandlerAdapter);
        lazyDynamicAdapter.afterPropertiesSet();
        return lazyDynamicAdapter;
    }

    @ConditionalOnBean(value={DataSource.class, LazyDynamicDatasourceAdapter.class})
    @ConditionalOnMissingBean(value={LazyOperationProxy.class})
    @Bean
    @Role(value=2)
    public LazyOperationProxy lazyOperationProxy(List<LazyOperationMethod> lazyOperationMethods, LazyDynamicDatasourceAdapter lazyDynamicAdapter, CureAdapter cureAdapter, LazyTranslationAdapter lazyTranslationAdapter) {
        return new LazyOperationProxy(lazyOperationMethods, lazyDynamicAdapter, cureAdapter, lazyTranslationAdapter);
    }

    @ConditionalOnMissingBean(value={LazySqlOperation.class})
    @ConditionalOnBean(value={LazyOperationProxy.class})
    @Bean
    @Role(value=2)
    public LazySqlOperation lazySqlOperation(LazyOperationProxy lazyOperationProxy) {
        return (LazySqlOperation)Proxy.newProxyInstance(LazySqlOperation.class.getClassLoader(), new Class[]{LazySqlOperation.class}, (InvocationHandler)lazyOperationProxy);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={LazySqlOperation.class})
    @Role(value=2)
    public LazyLambdaStream lazyLambdaStream(LazySqlOperation lazySqlOperation) {
        return new LazyLambdaStream((LazyBaseOperation)lazySqlOperation);
    }

    @ConditionalOnBean(value={LazyLambdaStream.class})
    @Role(value=2)
    @Bean
    @ConditionalOnMissingBean(value={SmartLazyOperationAutoStuffed.class})
    public SmartLazyOperationAutoStuffed smartLazyOperationAutoStuffed(LazyOperationAttribute operationConfig, LazyLambdaStream lazyLambdaStream) {
        return new LazyOperationSmartAutoStuffed(operationConfig, lazyLambdaStream);
    }

    @ConditionalOnBean(value={DataSource.class, LazyDynamicDatasourceAdapter.class})
    @ConditionalOnMissingBean(value={LazyDDLOperationProxy.class})
    @Bean
    @Role(value=2)
    public LazyDDLOperationProxy lazyDDLOperationProxy(List<LazyDDLOperationMethod> lazyDDLOperationMethodList, LazyDynamicDatasourceAdapter lazyDynamicAdapter) {
        return new LazyDDLOperationProxy(lazyDDLOperationMethodList, lazyDynamicAdapter);
    }

    @ConditionalOnBean(value={DataSource.class, LazyDDLOperationProxy.class})
    @Bean
    @Role(value=2)
    public LazyBaseDDLOperation lazyBaseDDLOperation(LazyDDLOperationProxy lazyDDLOperationProxy) {
        return (LazyBaseDDLOperation)Proxy.newProxyInstance(LazyBaseDDLOperation.class.getClassLoader(), new Class[]{LazyBaseDDLOperation.class}, (InvocationHandler)lazyDDLOperationProxy);
    }

    @ConditionalOnBean(value={DataSource.class, LazyDynamicDatasourceAdapter.class})
    @ConditionalOnMissingBean(value={LazyDQLOperationProxy.class})
    @Bean
    @Role(value=2)
    public LazyDQLOperationProxy lazyDQLOperationProxy(List<LazyDQLOperationMethod> lazyDQLOperationMethods, LazyDynamicDatasourceAdapter lazyDynamicAdapter, LazyTranslationAdapter lazyTranslationAdapter) {
        return new LazyDQLOperationProxy(lazyDQLOperationMethods, lazyDynamicAdapter, lazyTranslationAdapter);
    }

    @ConditionalOnBean(value={DataSource.class, LazyDQLOperationProxy.class})
    @Bean
    @Role(value=2)
    public LazyBaseDQLOperation lazyBaseDQLOperation(LazyDQLOperationProxy lazyDQLOperationProxy) {
        return (LazyBaseDQLOperation)Proxy.newProxyInstance(LazyBaseDQLOperation.class.getClassLoader(), new Class[]{LazyBaseDQLOperation.class}, (InvocationHandler)lazyDQLOperationProxy);
    }

    @ConditionalOnBean(value={DataSource.class, LazyLambdaStream.class})
    @ConditionalOnMissingBean(value={PerfectLazyOperation.class})
    @Bean
    @Role(value=2)
    public PerfectLazyOperation perfectLazyOperation(ExportDataProperties exportDataProperties, LazyLambdaStream lazyLambdaStream) {
        return new PerfectLazyOperation((ExportDataAttribute)exportDataProperties, lazyLambdaStream);
    }

    @ConditionalOnBean(value={DataSource.class, LazyOperation.class})
    @ConditionalOnMissingBean(value={LazyScanEntityBeanPostProcessor.class})
    @Bean
    @Role(value=2)
    public LazyScanEntityBeanPostProcessor lazyBeanPostProcessor(LazyOperation operation, LazyOperationAttribute operationConfig, LazyDataSourceAttribute lazyDataSourceAttribute, LazyDdlConfigureAttribute lazyDdlConfigureAttribute) {
        return new LazyScanEntityBeanPostProcessor(operation, operationConfig, lazyDataSourceAttribute, lazyDdlConfigureAttribute);
    }

    @Bean
    @Role(value=2)
    public LazyTranslationAPI lazyTableTranslationAPI() {
        return new LazyTableTranslationOneAPI();
    }

    @Bean
    @Role(value=2)
    public LazyTranslationAPI lazyTableTranslationOneToManyAPI() {
        return new LazyTableTranslationOneToManyAPI();
    }
}

