/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.inner.lazy.orm.spring.aop;

import java.lang.reflect.Method;
import lombok.NonNull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.ClassLazyDynamicEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDynamicEndpoint;
import org.wu.framework.lazy.orm.core.stereotype.LazyDS;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyDSContextHolder;

@Role(value=2)
public class LazyDynamicPointcutAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private final Advice advice;
    private final Pointcut pointcut;

    public LazyDynamicPointcutAdvisor(@NonNull LazyDBInterceptor lazyDBInterceptor) {
        if (lazyDBInterceptor == null) {
            throw new NullPointerException("lazyDBInterceptor is marked non-null but is null");
        }
        this.advice = lazyDBInterceptor;
        this.pointcut = this.buildPointcut();
    }

    private Pointcut buildPointcut() {
        AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(LazyDS.class, true);
        AnnotationMatchingPointcut mpc = AnnotationMatchingPointcut.forMethodAnnotation(LazyDS.class);
        AnnotationMatchingPointcut classAnnotation = AnnotationMatchingPointcut.forClassAnnotation(LazyDS.class);
        return new ComposablePointcut((Pointcut)cpc).union((Pointcut)mpc).union((Pointcut)classAnnotation);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    }

    public static class LazyDBInterceptor
    implements MethodInterceptor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            LazyDS lazyDS = this.determineLazyDS(invocation);
            ClassLazyDynamicEndpoint lazyDynamicEndpoint = new ClassLazyDynamicEndpoint();
            lazyDynamicEndpoint.setName(lazyDS.name());
            DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)lazyDynamicEndpoint);
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                DynamicLazyDSContextHolder.clear();
            }
        }

        public LazyDS determineLazyDS(MethodInvocation invocation) {
            Method method = invocation.getMethod();
            Class<?> declaringClass = method.getDeclaringClass();
            LazyDS lazyDS = method.isAnnotationPresent(LazyDS.class) ? method.getAnnotation(LazyDS.class) : (LazyDS)AnnotationUtils.findAnnotation(declaringClass, LazyDS.class);
            return lazyDS;
        }
    }
}

