/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class TcpScannerUtil {
    public static void main(String ... args) throws ExecutionException, InterruptedException {
        ExecutorService es = Executors.newFixedThreadPool(20);
        String ip = "192.168.17.221";
        int timeout = 200;
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (int port = 1; port <= 65535; ++port) {
            futures.add(TcpScannerUtil.portIsOpen(es, "192.168.17.221", port, 200));
        }
        es.shutdown();
        int openPorts = 0;
        for (Future future : futures) {
            if (!((Boolean)future.get()).booleanValue()) continue;
            ++openPorts;
        }
        System.out.println("There are " + openPorts + " open ports on host " + "192.168.17.221" + " (probed with a timeout of " + 200 + "ms)");
    }

    public static Future<Boolean> portIsOpen(ExecutorService es, final String ip, final int port, final int timeout) {
        return es.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(ip, port), timeout);
                    socket.close();
                    System.out.println("this port " + port + " is open ");
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        });
    }
}

