/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.exception.RuntimeExceptionFactory;
import org.wu.framework.core.utils.DefaultSocketHttpResponse;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.core.utils.SocketHttpResponse;

public class SocketSendUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SocketSendUtil.class);

    public static SocketHttpResponse sendCurlReceive(String ip, int port, String curl) {
        if (ObjectUtils.isNotEmpty(curl)) {
            String[] curlSplitList;
            StringBuilder builder = new StringBuilder();
            if (curl.startsWith("curl -X")) {
                curl = curl.replaceFirst("curl -X", "");
            }
            if (curl.startsWith("curl")) {
                curl = curl.replaceFirst(" ", "");
                curl = curl.replaceFirst("'", "");
                curl = curl.replaceFirst("curl", "GET\n");
            }
            for (String line : curlSplitList = curl.split("\n")) {
                if ((line = line.replaceAll(" ", "")).startsWith("-b")) continue;
                if (line.startsWith("-H")) {
                    line = line.replaceFirst("-H", "");
                }
                if (line.lastIndexOf("\\") > 0) {
                    line = line.substring(0, line.length() - 1);
                }
                if (line.startsWith("'") && line.endsWith("'")) {
                    line = line.substring(1, line.length() - 1);
                }
                if (!line.startsWith("http")) {
                    line = line.replaceAll(":", ": ");
                }
                line = line + "\n";
                builder.append(line);
            }
            System.out.println("send http with body:" + builder);
            return SocketSendUtil.sendAndReceive(ip, port, builder.toString().getBytes(StandardCharsets.UTF_8));
        }
        RuntimeExceptionFactory.of("\u89e3\u6790curl\u9519\u8bef");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketHttpResponse sendAndReceive(String ip, int port, byte[] msg) {
        StringBuilder requestBody = new StringBuilder();
        DefaultSocketHttpResponse socketHttpResponse = new DefaultSocketHttpResponse();
        try (Socket client = new Socket(ip, port);){
            String line;
            OutputStream out = client.getOutputStream();
            out.write(msg);
            InputStream in = client.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            StringBuilder requestHeader = new StringBuilder();
            while ((line = reader.readLine()) != null && !line.isEmpty()) {
                requestHeader.append(line).append("\r\n");
            }
            socketHttpResponse.setHeader(requestHeader.toString());
            if (reader.ready()) {
                int bytesRead;
                char[] buffer = new char[1024];
                while ((bytesRead = reader.read(buffer)) != -1) {
                    requestBody.append(buffer, 0, bytesRead);
                }
            }
            socketHttpResponse.setBody(requestBody.toString());
            StringBuilder response = new StringBuilder();
            response.append((CharSequence)requestHeader);
            response.append((CharSequence)requestBody);
            int statusCode = SocketSendUtil.getStatusCode(response.toString());
            socketHttpResponse.setHttpStatus(statusCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            socketHttpResponse.setHttpStatus(500);
            socketHttpResponse.setBody(e.getMessage());
            DefaultSocketHttpResponse defaultSocketHttpResponse = socketHttpResponse;
            return defaultSocketHttpResponse;
        }
        return socketHttpResponse;
    }

    private static int getStatusCode(String response) {
        String[] statusLineParts;
        String[] lines = response.split("\r\n");
        if (lines.length > 0 && (statusLineParts = lines[0].split(" ")).length > 1) {
            return Integer.parseInt(statusLineParts[1]);
        }
        return -1;
    }

    public static void main(String[] args) {
        String s = "POST http://tenant-cloud-gateway:7777/management-cloud-gateway-forward/management-lms-online-retailers-provide/api/lms/online/service/salesOrder/getSalesDpOrder?customerId=2740 HTTP/1.0\nfeign_header_name: feign_header_name\nfeign_header_time_name: 563498334-\nAccept: */*\nUser-Agent: Java/17.0.7\nContent-type: application/x-www-form-urlencoded\nX-Forwarded-For: 10.244.2.204,10.244.2.204\nX-Forwarded-Proto: http,http\nX-Forwarded-Prefix: /under-cloud-central-gateway\nX-Forwarded-Port: 7777,7777\nX-Forwarded-Host: tenant-cloud-gateway:7777,tenant-cloud-gateway:7777\nhost: 10.244.1.225:7002\nrequest_id: 6bee4459-854082\nrequest_times: 2\ntenant_id: 2561\nversion: middleground-2.5.8-SNAPSHOT\n6bee4459-854082: true\nForwarded: proto=http;host=\"tenant-cloud-gateway:7777\";for=\"10.244.2.204:47368\"\nForwarded: proto=http;host=\"10.244.1.225:7002\";for=\"10.244.2.204:47368\"\ncontent-length: 0\n\nis_off_line: true\n";
        SocketHttpResponse result = SocketSendUtil.sendAndReceive("ly.laihui.cn", 30570, s.getBytes());
        System.out.println(result);
        String curl = "curl 'https://www.zhipin.com/wapi/zpgeek/pc/recommend/job/list.json?page=1&pageSize=15&city=101210100&encryptExpectId=&mixExpectType=&expectInfo=&jobType=&salary=&experience=&degree=&industry=&scale=&_=1752236680609' \\\n  -H 'accept: application/json, text/plain, */*' \\\n  -H 'accept-language: zh-CN,zh;q=0.9' \\\n  -b 'lastCity=101210100; __zp_seo_uuid__=c127a66a-c32b-48c8-9922-38e68f276ceb; __l=r=https%3A%2F%2Fwww.google.com%2F&l=%2F&s=1; __g=-; Hm_lvt_194df3105ad7148dcf2b98a91b5e727a=1752227729; HMACCOUNT=E12FA8317F1FBEC2; wt2=DcZwnO_EigAmnmKo9ncVkLjm_VmGSQbYrNCtyZSlL6OQAcvq5C35SkpTxRDYFH8U7RrhTb80BENIxGag1RXDjHw~~; wbg=0; zp_at=p2KdHC6P5beWE8bSoHrWbW1ap7pNQcti2oo78rbNc6M~; ab_guid=c71d5784-aec0-4eb6-adea-9c538b7e331b; Hm_lpvt_194df3105ad7148dcf2b98a91b5e727a=1752230985; bst=V2Qt0mEOf-21lgXdJszRQdKC2w7DrTzQ~~|Qt0mEOf-21lgXdJszRQdKC2w7DvSzQ~~; __c=1752227729; __a=78645062.1752227729..1752227729.13.1.13.13; __zp_stoken__=771dfOTbDlsK9wpvCtD0vDwkJCQAwIDA2Kio4OSIyPDw5Njw%2BPjk2NBwwKcO7wrzCsDZJW8ONJzkiNjw1OTk4PDw6EjYwxLrCsDY5KcKRwrnCvTlMVcOABMK%2Fwr0RPcK5B8O0wr0EwoPCsxFowrkjJCzCvzAwOz3DgcK3wpDCusOBwr7CkMK9H8K%2Bwp3CvTAzPWUqNA4AX1k0M0hKVwJFVE1hWFELQktLJT0wNjk9wrfDvSw3CQ8PBgYJDw8GBgYMDAoKBgwMCQkDDQ0AAC48wpXCsMO8wo9ZwpDDosSWwpDCrsOqQ8KXwpLCm0nDtFPCrcK0w7vCtcKpwrvCtlHCo0rCr1vCiF%2FCocK1wpBkV15uRk97wrZvV8K%2FV2PCs1bDgWkKWwIEETQLXF3DgA%3D%3D' \\\n  -H 'priority: u=1, i' \\\n  -H 'referer: https://www.zhipin.com/web/geek/jobs?city=101210100' \\\n  -H 'sec-ch-ua: \"Not)A;Brand\";v=\"8\", \"Chromium\";v=\"138\", \"Google Chrome\";v=\"138\"' \\\n  -H 'sec-ch-ua-mobile: ?0' \\\n  -H 'sec-ch-ua-platform: \"macOS\"' \\\n  -H 'sec-fetch-dest: empty' \\\n  -H 'sec-fetch-mode: cors' \\\n  -H 'sec-fetch-site: same-origin' \\\n  -H 'token: KhReS6dNmtMj1us' \\\n  -H 'traceid: F-71e5a1svdUstoQK9' \\\n  -H 'user-agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36' \\\n  -H 'x-requested-with: XMLHttpRequest' \\\n  -H 'zp_token: V2Qt0mEOf-21lgXdJszRQdKC2w7DrTzQ~~|Qt0mEOf-21lgXdJszRQdKC2w7DvSzQ~~'";
        SocketHttpResponse socketHttpResponse = SocketSendUtil.sendCurlReceive("www.zhipin.com", 443, curl);
        System.out.println(socketHttpResponse);
    }
}

