/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.io.File;
import java.io.FileFilter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageClassUtil {
    private static final Logger log = LoggerFactory.getLogger(PackageClassUtil.class);

    public static Set<Class<?>> getClasses(String pack) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    PackageClassUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            Class<?> forName = Class.forName(packageName + '.' + className);
                            classes.add(forName);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            log.error("\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6");
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    log.error("\u5728\u626b\u63cf\u7528\u6237\u5b9a\u4e49\u89c6\u56fe\u65f6\u4ecejar\u5305\u83b7\u53d6\u6587\u4ef6\u51fa\u9519" + e.getMessage());
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                PackageClassUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Class.forName(packageName + '.' + className));
            }
            catch (Throwable e) {
                log.error("\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6");
                e.printStackTrace();
            }
        }
    }
}

