/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyListUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LazyListUtils.class);
    public static final ExecutorService executorService = Executors.newFixedThreadPool(10);

    public static <T> List<List<T>> splitList(List<T> source, int groupSize) {
        int length = source.size();
        int num = (length + groupSize - 1) / groupSize;
        ArrayList<List<T>> newList = new ArrayList<List<T>>(num);
        for (int i = 0; i < num; ++i) {
            int fromIndex = i * groupSize;
            int toIndex = Math.min((i + 1) * groupSize, length);
            newList.add(source.subList(fromIndex, toIndex));
        }
        return newList;
    }

    public static <T> void splitListThen(List<T> source, int groupSize, Consumer<List<T>> listConsumer) throws ExecutionException, InterruptedException {
        Integer total = (source.size() + groupSize - 1) / groupSize;
        log.info("\u8ba1\u5212\u5904\u7406\u6b65\u9aa4 \u3010{}\u3011 \u6b65", (Object)total);
        AtomicInteger stepCount = new AtomicInteger(0);
        for (List ts : LazyListUtils.splitList(source, groupSize)) {
            stepCount.getAndIncrement();
            Future<?> submit = executorService.submit(() -> {
                listConsumer.accept(ts);
                log.info("\u5904\u7406\u6b65\u9aa4\u7b2c \u3010{}\u3011 \u6b65 ,\u603b\u6b65\u6570 \u3010{}\u3011", (Object)stepCount, (Object)total);
            });
            submit.get();
        }
    }
}

