/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.utils.DataTransformUntil;

public class InterfaceAutomaticUnitTest {
    private static Logger log = LoggerFactory.getLogger(InterfaceAutomaticUnitTest.class);

    public static void run(Object bean) {
        InterfaceAutomaticUnitTest.run(bean, bean.getClass());
    }

    public static <T> void run(Object bean, Class<?> beanClass) {
        Method[] methods;
        for (Method method : methods = beanClass.getDeclaredMethods()) {
            method.setAccessible(true);
            String name = method.getName();
            if ("$deserializeLambda$".equals(name) || name.equals(bean.getClass().getSimpleName())) continue;
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Object[] parameter = Arrays.stream(genericParameterTypes).map(type -> {
                if (ParameterizedType.class.isAssignableFrom(type.getClass())) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                    if (parameterizedType.getRawType().equals(List.class)) {
                        return DataTransformUntil.simulationBeanList((Class)actualTypeArguments[0], 10);
                    }
                    if (parameterizedType.getRawType().equals(Map.class)) {
                        // empty if block
                    }
                    return DataTransformUntil.simulationBean((Class)parameterizedType.getRawType());
                }
                if (Class.class.isAssignableFrom(type.getClass())) {
                    return DataTransformUntil.simulationBean((Class)type);
                }
                log.error("i can not analysis the method of param:{}", (Object)type.getTypeName());
                return null;
            }).toArray();
            Object invoke = null;
            try {
                invoke = method.invoke(bean, parameter);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            log.info("\u6267\u884c\u65b9\u6cd5\u3010{}#{}\u3011,\u8fd4\u56de\u6570\u636e:\uff1a\u3010{}\u3011", new Object[]{bean.getClass().getName(), method.getName(), invoke});
        }
    }
}

