/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.UUID;
import org.wu.framework.core.utils.ObjectUtils;

public class HttpFileUtil {
    public static BufferedReader getNetUrlHttpBufferedReader(String netUrl) {
        BufferedReader bufferedReader = null;
        try {
            URL url = new URL(netUrl);
            bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bufferedReader;
    }

    public static InputStream readInputStream(String netUrl) {
        try {
            URL url = new URL(netUrl);
            InputStream inputStream = url.openStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readStream(String netUrl) {
        try {
            URL url = new URL(netUrl);
            InputStream inputStream = url.openStream();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            outStream.close();
            inputStream.close();
            return outStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getNetUrlHttp(String netUrl) {
        String fileName = HttpFileUtil.reloadFile(netUrl);
        File file = null;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            file = File.createTempFile("net_url", fileName);
            URL url = new URL(netUrl);
            bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            int BUFFER_SIZE = 4096;
            char[] buffer = new char[BUFFER_SIZE];
            int charsRead = 0;
            while ((charsRead = bufferedReader.read(buffer, 0, BUFFER_SIZE)) != -1) {
                bufferedWriter.write(buffer, 0, charsRead);
            }
            bufferedWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != bufferedWriter) {
                    bufferedWriter.close();
                }
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static String reloadFile(String oleFileName) {
        if (ObjectUtils.isEmpty(oleFileName = HttpFileUtil.getFileName(oleFileName))) {
            return oleFileName;
        }
        if (!oleFileName.contains(".")) {
            return UUID.randomUUID().toString();
        }
        String[] arr = oleFileName.split("\\.");
        return UUID.randomUUID() + "." + arr[arr.length - 1];
    }

    public static String getFileName(String url) {
        if (ObjectUtils.isEmpty(url)) {
            return url;
        }
        String newUrl = url;
        newUrl = newUrl.split("[?]")[0];
        String[] bb = newUrl.split("/");
        return bb[bb.length - 1];
    }
}

