/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.enums.SimulationEnum;

public class DataTransformUntil {
    public static final List<String> IGNORE_FIELD_LIST = Collections.singletonList("serialVersionUID");

    public static void transform(Class<?> source, Class<?> target) {
        String targetName = DataTransformUntil.lowerFirst(target.getSimpleName());
        String sourceName = DataTransformUntil.lowerFirst(source.getSimpleName());
        if (source.isAnnotation()) {
            Method[] sourceDeclaredMethods = source.getDeclaredMethods();
            Field[] targetDeclaredFields = target.getDeclaredFields();
            System.out.printf("if(null==%s){%n", sourceName);
            System.out.println("            return null;");
            System.out.println("        }");
            System.out.printf("%s %s = new %s();%n", target.getSimpleName(), targetName, target.getSimpleName());
            for (Method sourceDeclaredMethod : sourceDeclaredMethods) {
                String sourceDeclaredMethodName = sourceDeclaredMethod.getName();
                boolean anyMatch = Arrays.stream(targetDeclaredFields).anyMatch(field -> field.getType().equals(sourceDeclaredMethod.getReturnType()) & field.getName().equals(sourceDeclaredMethodName));
                if (!anyMatch || IGNORE_FIELD_LIST.contains(sourceDeclaredMethodName)) continue;
                String field1Name = DataTransformUntil.upFirst(sourceDeclaredMethodName);
                System.out.printf("%s.set%s(%s.%s());%n", targetName, field1Name, sourceName, sourceDeclaredMethodName);
            }
        } else {
            Field[] sourceDeclaredFields = source.getDeclaredFields();
            Field[] targetDeclaredFields = target.getDeclaredFields();
            System.out.printf("if(null==%s){%n", sourceName);
            System.out.println("            return null;");
            System.out.println("        }");
            System.out.printf("%s %s = new %s();%n", target.getSimpleName(), targetName, target.getSimpleName());
            for (Field sourceDeclaredField : sourceDeclaredFields) {
                boolean anyMatch = Arrays.stream(targetDeclaredFields).anyMatch(field -> field.getType().equals(sourceDeclaredField.getType()) & field.getName().equals(sourceDeclaredField.getName()));
                if (!anyMatch || IGNORE_FIELD_LIST.contains(sourceDeclaredField.getName())) continue;
                String field1Name = DataTransformUntil.upFirst(sourceDeclaredField.getName());
                System.out.printf("%s.set%s(%s.get%s());%n", targetName, field1Name, sourceName, field1Name);
            }
        }
        System.out.printf("            return %s;", targetName);
    }

    public static void transformAnnotation(Class<? extends Annotation> source) {
        Method[] sourceDeclaredMethods = source.getDeclaredMethods();
        System.out.printf("public class %sEndPoint{%n", source.getSimpleName());
        for (Method sourceDeclaredMethod : sourceDeclaredMethods) {
            Class<?> returnType = sourceDeclaredMethod.getReturnType();
            String name = sourceDeclaredMethod.getName();
            if (IGNORE_FIELD_LIST.contains(name)) continue;
            System.out.printf(" private %s %s;%n", returnType.getSimpleName(), name);
        }
        System.out.println("}");
    }

    public static void contrastField(Class<?> source, Class<?> target) {
        Field[] sourceDeclaredFields = source.getDeclaredFields();
        Field[] targetDeclaredFields = target.getDeclaredFields();
        String targetName = DataTransformUntil.lowerFirst(target.getSimpleName());
        String sourceName = DataTransformUntil.lowerFirst(source.getSimpleName());
        System.out.print("\u5b57\u6bb5\u540d\u79f0");
        System.out.printf("        \u539f\u59cb\u6570\u636e\u5b57\u6bb5\u7c7b\u578b(%s)", source.getSimpleName());
        System.out.printf("        \u76ee\u6807\u6570\u636e\u5b57\u6bb5\u7c7b\u578b:(%s)%n", target.getSimpleName());
        Map sourceDeclaredFieldMap = Arrays.stream(sourceDeclaredFields).collect(Collectors.toConcurrentMap(Field::getName, Function.identity(), (A, B) -> A));
        Map targetDeclaredFieldMap = Arrays.stream(targetDeclaredFields).collect(Collectors.toConcurrentMap(Field::getName, Function.identity(), (A, B) -> A));
        for (Field sourceDeclaredField : sourceDeclaredFields) {
            boolean anyMatch = Arrays.stream(targetDeclaredFields).anyMatch(field -> !field.getType().equals(sourceDeclaredField.getType()) & field.getName().equals(sourceDeclaredField.getName()));
            if (!anyMatch || IGNORE_FIELD_LIST.contains(sourceDeclaredField.getName())) continue;
            String fieldName = sourceDeclaredField.getName();
            System.out.printf("%s %s %s %n", fieldName, sourceDeclaredField.getType(), ((Field)targetDeclaredFieldMap.get(fieldName)).getType());
        }
    }

    private static String upFirst(String name) {
        return CamelAndUnderLineConverter.capitalizeFirstLetter(name);
    }

    private static String lowerFirst(String name) {
        return CamelAndUnderLineConverter.lowercaseFirstLetter(name);
    }

    public static void simulationData(Class<?> source) {
        DataTransformUntil.simulationData(source, false);
    }

    public static void simulationData(Class<?> source, boolean chain) {
        String sourceBeanName = DataTransformUntil.lowerFirst(source.getSimpleName());
        System.out.printf("%s %s = new %s();%n", source.getSimpleName(), sourceBeanName, source.getSimpleName());
        if (chain) {
            System.out.println(sourceBeanName);
        }
        for (Field declaredField : source.getDeclaredFields()) {
            if (IGNORE_FIELD_LIST.contains(declaredField.getName())) continue;
            String fieldName = DataTransformUntil.upFirst(declaredField.getName());
            Class<?> type = declaredField.getType();
            SimulationEnum.SimulationStrategy orDefault = SimulationEnum.SIMULATION_MAP.getOrDefault(type, new SimulationEnum.DefaultSimulationStrategy());
            if (chain) {
                System.out.printf(".set%s(%s)%n", fieldName, orDefault.text());
                continue;
            }
            System.out.printf("%s.set%s(%s);%n", sourceBeanName, fieldName, orDefault.strategy());
        }
        if (chain) {
            System.out.println(";");
        }
    }

    public static <T> T simulationBean(Class<T> source) {
        try {
            if (SimulationEnum.SIMULATION_MAP.containsKey(source)) {
                return DataTransformUntil.simulationBaseBean(source, null);
            }
            T t = source.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field declaredField : source.getDeclaredFields()) {
                if (IGNORE_FIELD_LIST.contains(declaredField.getName())) continue;
                Class<?> fieldType = declaredField.getType();
                Object fieldValue = null;
                if (SimulationEnum.SIMULATION_MAP.containsKey(fieldType)) {
                    SimulationEnum.SimulationStrategy orDefault = SimulationEnum.SIMULATION_MAP.getOrDefault(fieldType, new SimulationEnum.DefaultSimulationStrategy());
                    fieldValue = orDefault.strategy();
                } else {
                    Type genericType = declaredField.getGenericType();
                    if (genericType instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)genericType;
                        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                        Type rawType = parameterizedType.getRawType();
                        if (Collection.class.isAssignableFrom((Class)rawType)) {
                            Class actualTypeArgument = (Class)actualTypeArguments[0];
                            fieldValue = DataTransformUntil.simulationBeanList(actualTypeArgument, 10);
                        } else if (rawType instanceof Map) {
                            Type mapKeyType = actualTypeArguments[0];
                            Type mapValueType = actualTypeArguments[1];
                            HashMap objectObjectHashMap = new HashMap();
                            objectObjectHashMap.put(DataTransformUntil.simulationBean(mapKeyType.getClass()), DataTransformUntil.simulationBean(mapValueType.getClass()));
                            fieldValue = objectObjectHashMap;
                        }
                    } else {
                        fieldValue = DataTransformUntil.simulationBean(fieldType);
                    }
                }
                Method declaredMethod = source.getDeclaredMethod("set" + DataTransformUntil.upFirst(declaredField.getName()), fieldType);
                declaredMethod.invoke(t, fieldValue);
            }
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> simulationBeanList(Class<T> source, int length) {
        ArrayList<T> sourceList = new ArrayList<T>();
        for (int i = 0; i < length; ++i) {
            T t = DataTransformUntil.simulationBean(source);
            sourceList.add(t);
        }
        return sourceList;
    }

    public static <T> T simulationBaseBean(Class<T> source, Integer length) {
        if (SimulationEnum.SIMULATION_MAP.containsKey(source)) {
            return (T)SimulationEnum.SIMULATION_MAP.get(source).strategy(length);
        }
        throw new IllegalArgumentException("\u4eff\u771f\u57fa\u7840\u6570\u636e\u7c7b\u578b\u9519\u8bef:\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b" + source);
    }

    public static <T> T copyBean(Object source) {
        if (source == null) {
            return null;
        }
        try {
            Class<?> sourceClass = source.getClass();
            Object t = sourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field declaredField : sourceClass.getDeclaredFields()) {
                if (IGNORE_FIELD_LIST.contains(declaredField.getName())) continue;
                declaredField.setAccessible(true);
                Object fieldValue = declaredField.get(source);
                declaredField.set(t, fieldValue);
            }
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T transformBean(Object source, Class<T> targetType) {
        Field[] sourceDeclaredFields = source.getClass().getDeclaredFields();
        Map<String, Field> sourceFieldMap = Arrays.stream(sourceDeclaredFields).collect(Collectors.toMap(Field::getName, field -> field, (A, B) -> A));
        try {
            if (Map.class.isAssignableFrom(targetType)) {
                HashMap<String, Object> targetMap = new HashMap<String, Object>();
                if (source instanceof Map) {
                    ((Map)source).forEach((k, v) -> targetMap.put(k.toString(), v));
                } else {
                    for (Field sourceDeclaredField : sourceDeclaredFields) {
                        if (IGNORE_FIELD_LIST.contains(sourceDeclaredField.getName())) continue;
                        sourceDeclaredField.setAccessible(true);
                        String k2 = sourceDeclaredField.getName();
                        Object v2 = sourceDeclaredField.get(source);
                        targetMap.put(k2, v2);
                    }
                }
                return (T)targetMap;
            }
            Field[] targetDeclaredFields = targetType.getDeclaredFields();
            T targetNewInstance = targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field targetDeclaredField : targetDeclaredFields) {
                Class<?> targetFieldType = targetDeclaredField.getType();
                String name = targetDeclaredField.getName();
                boolean exist = Arrays.stream(sourceDeclaredFields).anyMatch(sourceField -> sourceField.getName().equals(name) && targetFieldType.isAssignableFrom(sourceField.getType()));
                if (!exist) continue;
                Field sourceField2 = sourceFieldMap.get(name);
                sourceField2.setAccessible(true);
                Object sourceFieldValue = sourceField2.get(source);
                targetDeclaredField.setAccessible(true);
                targetDeclaredField.set(targetNewInstance, sourceFieldValue);
            }
            return targetNewInstance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

