/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComputerUniqueIdUtil {
    private static final Logger logger = Logger.getLogger(ComputerUniqueIdUtil.class.getName());

    public static void main(String[] args) {
        OS osType = ComputerUniqueIdUtil.getOperatingSystem();
        System.out.println("\u64cd\u4f5c\u7cfb\u7edf: " + (Object)((Object)osType));
        String motherboardSerial = ComputerUniqueIdUtil.getMotherboardSerialNumber();
        System.out.println("\u4e3b\u677f\u5e8f\u5217\u53f7: " + (motherboardSerial.isEmpty() ? "\u65e0\u6cd5\u83b7\u53d6" : motherboardSerial));
        String diskSerial = ComputerUniqueIdUtil.getPrimaryDiskSerialNumber();
        System.out.println("\u786c\u76d8\u5e8f\u5217\u53f7: " + (diskSerial.isEmpty() ? "\u65e0\u6cd5\u83b7\u53d6" : diskSerial));
        String cpuId = ComputerUniqueIdUtil.getCpuId();
        System.out.println("CPU ID: " + (cpuId.isEmpty() ? "\u65e0\u6cd5\u83b7\u53d6" : cpuId));
        String uniqueId = ComputerUniqueIdUtil.generateUniqueId();
        System.out.println("\n\u7efc\u5408\u552f\u4e00\u6807\u8bc6\u7b26: " + (uniqueId.isEmpty() ? "\u751f\u6210\u5931\u8d25" : uniqueId));
    }

    public static OS getOperatingSystem() {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("win")) {
                return OS.WINDOWS;
            }
            if (osName.contains("mac")) {
                return OS.MAC;
            }
            if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
                return OS.LINUX;
            }
            return OS.UNKNOWN;
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, "\u83b7\u53d6\u64cd\u4f5c\u7cfb\u7edf\u4fe1\u606f\u65f6\u53d1\u751f\u5b89\u5168\u5f02\u5e38", e);
            return OS.UNKNOWN;
        }
    }

    public static String generateUniqueId() {
        ArrayList<String> hardwareInfos = new ArrayList<String>();
        hardwareInfos.add(ComputerUniqueIdUtil.getMotherboardSerialNumber());
        hardwareInfos.add(ComputerUniqueIdUtil.getPrimaryDiskSerialNumber());
        hardwareInfos.add(ComputerUniqueIdUtil.getCpuId());
        StringBuilder infoBuilder = new StringBuilder();
        for (String info : hardwareInfos) {
            infoBuilder.append(info).append("|");
        }
        try {
            return ComputerUniqueIdUtil.md5Encrypt(infoBuilder.toString());
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "MD5\u52a0\u5bc6\u5931\u8d25", e);
            return "";
        }
    }

    public static String getMotherboardSerialNumber() {
        OS os = ComputerUniqueIdUtil.getOperatingSystem();
        String result = "";
        try {
            switch (os) {
                case WINDOWS: {
                    result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("wmic", "baseboard", "get", "serialnumber"));
                    result = ComputerUniqueIdUtil.extractValue(result, "SerialNumber");
                    break;
                }
                case MAC: {
                    result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("ioreg", "-l", "|", "grep", "IOPlatformSerialNumber"));
                    result = ComputerUniqueIdUtil.extractMacSerial(result, "IOPlatformSerialNumber");
                    break;
                }
                case LINUX: {
                    result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("sudo", "dmidecode", "-s", "system-serial-number"));
                    if (result.isEmpty() || result.contains("Not Applicable")) {
                        result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("dmidecode", "-s", "system-serial-number"));
                    }
                    break;
                }
                default: {
                    result = "";
                    logger.warning("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7cfb\u7edf\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e3b\u677f\u5e8f\u5217\u53f7");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "\u83b7\u53d6\u4e3b\u677f\u5e8f\u5217\u53f7\u5931\u8d25", e);
            result = "";
        }
        return result.trim();
    }

    public static String getPrimaryDiskSerialNumber() {
        OS os = ComputerUniqueIdUtil.getOperatingSystem();
        String result = "";
        try {
            switch (os) {
                case WINDOWS: {
                    result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("wmic", "diskdrive", "where", "index=0", "get", "serialnumber"));
                    result = ComputerUniqueIdUtil.extractValue(result, "SerialNumber");
                    break;
                }
                case MAC: {
                    result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("diskutil", "info", "/", "|", "grep", "Volume Serial Number"));
                    result = ComputerUniqueIdUtil.extractMacSerial(result, "Volume Serial Number");
                    break;
                }
                case LINUX: {
                    result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("lsblk", "-n", "-o", "SERIAL", "/dev/sda"));
                    if (result.isEmpty()) {
                        result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("lsblk", "-n", "-o", "SERIAL", "/dev/vda"));
                    }
                    break;
                }
                default: {
                    result = "";
                    logger.warning("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7cfb\u7edf\uff0c\u65e0\u6cd5\u83b7\u53d6\u786c\u76d8\u5e8f\u5217\u53f7");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "\u83b7\u53d6\u786c\u76d8\u5e8f\u5217\u53f7\u5931\u8d25", e);
            result = "";
        }
        return result.trim();
    }

    public static String getCpuId() {
        OS os = ComputerUniqueIdUtil.getOperatingSystem();
        String result = "";
        try {
            switch (os) {
                case WINDOWS: {
                    result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("wmic", "cpu", "get", "processorid"));
                    result = ComputerUniqueIdUtil.extractValue(result, "ProcessorId");
                    break;
                }
                case MAC: {
                    result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("sysctl", "-n", "machdep.cpu.brand_string"));
                    break;
                }
                case LINUX: {
                    result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("grep", "-m", "1", "^processor", "/proc/cpuinfo"));
                    if (result.isEmpty()) {
                        result = ComputerUniqueIdUtil.executeCommand(Arrays.asList("cat", "/proc/cpuinfo", "|", "grep", "model name", "|", "head", "-n", "1"));
                    }
                    break;
                }
                default: {
                    result = "";
                    logger.warning("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7cfb\u7edf\uff0c\u65e0\u6cd5\u83b7\u53d6CPU ID");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "\u83b7\u53d6CPU ID\u5931\u8d25", e);
            result = "";
        }
        return result.trim();
    }

    /*
     * Exception decompiling
     */
    private static String executeCommand(List<String> command) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String extractValue(String output, String label) {
        String[] lines;
        if (output.isEmpty()) {
            return "";
        }
        for (String line : lines = output.split("\n")) {
            if (line == null || line.trim().equalsIgnoreCase(label) || line.trim().isEmpty()) continue;
            return line.trim();
        }
        return "";
    }

    private static String extractMacSerial(String output, String label) {
        String[] lines;
        if (output.isEmpty()) {
            return "";
        }
        for (String line : lines = output.split("\n")) {
            String[] parts;
            if (line == null || !line.contains(label) || (parts = line.split("=")).length <= 1) continue;
            return parts[1].trim().replace("\"", "");
        }
        return "";
    }

    private static String md5Encrypt(String input) throws NoSuchAlgorithmException {
        if (input.isEmpty()) {
            return "";
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] messageDigest = md.digest(input.getBytes());
        StringBuilder hexString = new StringBuilder();
        for (byte b : messageDigest) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static enum OS {
        WINDOWS,
        MAC,
        LINUX,
        UNKNOWN;

    }
}

